/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.sql2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import nl.vpro.jcr.criteria.query.sql2.Condition;

public abstract class BooleanCondition
implements Condition {
    final List<Condition> clauses = new ArrayList<Condition>();

    protected BooleanCondition(Condition ... clauses) {
        this.clauses.addAll(Arrays.asList(clauses));
    }

    abstract String getBooleanOperator();

    @Override
    public boolean toSql2(StringBuilder builder) {
        int location = builder.length();
        int appendCount = 0;
        String op = this.getBooleanOperator();
        for (Condition clause : this.clauses) {
            if (appendCount > 0) {
                builder.append(op);
            }
            if (!clause.toSql2(builder)) continue;
            ++appendCount;
        }
        if (appendCount > 1) {
            builder.insert(location, '(');
            builder.append(')');
        }
        return appendCount > 0;
    }

    public boolean hasClauses() {
        return !this.clauses.isEmpty();
    }

    @Generated
    public List<Condition> getClauses() {
        return this.clauses;
    }
}

