/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.impl;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import javax.jcr.Session;
import lombok.Generated;
import nl.vpro.jcr.criteria.advanced.impl.AdvancedCriteriaImpl;
import nl.vpro.jcr.criteria.advanced.impl.AdvancedResultImpl;
import nl.vpro.jcr.criteria.advanced.impl.QueryExecutorHelper;
import nl.vpro.jcr.criteria.query.AdvancedResult;
import nl.vpro.jcr.criteria.query.Criteria;
import nl.vpro.jcr.criteria.query.JCRCriteriaFactory;
import nl.vpro.jcr.criteria.query.TranslatableCriteria;
import nl.vpro.jcr.criteria.query.criterion.Criterion;
import nl.vpro.jcr.criteria.query.criterion.Junction;
import nl.vpro.jcr.criteria.query.criterion.Order;
import nl.vpro.jcr.criteria.query.impl.Column;
import nl.vpro.jcr.criteria.query.sql2.Select;
import nl.vpro.jcr.criteria.query.xpath.CriteriaQueryTranslator;
import nl.vpro.jcr.criteria.query.xpath.XPathSelect;
import nl.vpro.jcr.criteria.query.xpath.utils.XPathTextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCriteriaImpl
implements TranslatableCriteria {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCriteriaImpl.class);
    protected String basePath = "//*";
    protected String type;
    protected List<TranslatableCriteria.CriterionEntry> criterionEntries = new ArrayList<TranslatableCriteria.CriterionEntry>();
    protected List<TranslatableCriteria.OrderEntry> orderEntries = new ArrayList<TranslatableCriteria.OrderEntry>();
    protected List<Column> columns = new ArrayList<Column>();
    protected Integer maxResults;
    protected int firstResult;
    protected String spellCheckString;
    protected boolean forcePagingWithDocumentOrder;
    protected String language = null;
    private ZoneId timeZone;

    protected AbstractCriteriaImpl() {
    }

    @Override
    public Collection<TranslatableCriteria.CriterionEntry> getCriterionEntries() {
        return Collections.unmodifiableCollection(this.criterionEntries);
    }

    @Override
    public Collection<TranslatableCriteria.OrderEntry> getOrderEntries() {
        return Collections.unmodifiableCollection(this.orderEntries);
    }

    @Override
    public AbstractCriteriaImpl add(Criterion criterion) {
        if (criterion instanceof Junction) {
            ((Junction)criterion).setOuter(false);
        }
        this.criterionEntries.add(new TranslatableCriteria.CriterionEntry(criterion, this));
        return this;
    }

    @Override
    public AbstractCriteriaImpl addOrder(Order order) {
        this.orderEntries.add(new TranslatableCriteria.OrderEntry(order, this));
        return this;
    }

    @Override
    public AbstractCriteriaImpl addOrderByScore() {
        this.orderEntries.add(new TranslatableCriteria.OrderEntry(Order.SCORE, this));
        return this;
    }

    @Override
    public AbstractCriteriaImpl setBasePath(String path) {
        if (!XPathTextUtils.isValidNodePath(path)) {
            throw new IllegalArgumentException("Path " + path + " is not a valid node path");
        }
        this.basePath = path;
        return this;
    }

    @Override
    @Deprecated
    public Criteria.Expression toXpathExpression() {
        CriteriaQueryTranslator translator = new CriteriaQueryTranslator(this);
        XPathSelect statement = new XPathSelect();
        statement.setType(this.type);
        if (!"//*".equals(this.basePath) && this.basePath != null) {
            statement.setRoot(XPathTextUtils.toXPath(this.basePath));
        }
        statement.setPredicate(translator.getPredicate());
        statement.setOrderByClause(translator.getOrderBy());
        return Criteria.Expression.xpath(statement.toStatementString());
    }

    @Override
    public Criteria.Expression toSql2Expression() {
        return Criteria.Expression.sql2(Select.from(this).toSql2());
    }

    @Override
    public AdvancedResult execute(Session session, String language) {
        if (language == null) {
            language = this.language;
        }
        Criteria.Expression expr = this.toExpression(language);
        return QueryExecutorHelper.execute(expr, this.getCountSupplier(session, language), session, this.maxResults, this.firstResult, this.spellCheckString, this.forcePagingWithDocumentOrder && this.orderEntries.isEmpty());
    }

    @Override
    public LongSupplier getCountSupplier(Session session, String language) {
        return () -> {
            long l;
            block6: {
                long duration;
                Criteria.Expression expr;
                block5: {
                    long startTime = System.nanoTime();
                    expr = null;
                    try {
                        long totalSize;
                        AdvancedCriteriaImpl countCriteria = JCRCriteriaFactory.createCriteria();
                        for (TranslatableCriteria.CriterionEntry c : this.getCriterionEntries()) {
                            countCriteria.add(c.getCriterion());
                        }
                        countCriteria.setBasePath(this.basePath);
                        countCriteria.setType(this.type);
                        countCriteria.setSpellCheckString(this.spellCheckString);
                        expr = countCriteria.toExpression(language);
                        AdvancedResultImpl result = QueryExecutorHelper.execute(expr, () -> -1L, session, null, 0, this.spellCheckString, this.forcePagingWithDocumentOrder && this.orderEntries.isEmpty());
                        l = totalSize = result.getTotalSize();
                        duration = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
                        if (duration <= 50L) break block5;
                    }
                    catch (Throwable throwable) {
                        long duration2 = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
                        if (duration2 > 50L) {
                            log.info("Total size was not available for {}, determining it took {} ms", expr, (Object)duration2);
                        } else {
                            log.debug("Total size was not available for {}, determining it took {} ms", expr, (Object)duration2);
                        }
                        throw throwable;
                    }
                    log.info("Total size was not available for {}, determining it took {} ms", (Object)expr, (Object)duration);
                    break block6;
                }
                log.debug("Total size was not available for {}, determining it took {} ms", (Object)expr, (Object)duration);
            }
            return l;
        };
    }

    public String toString() {
        return "criteria" + (this.type != null ? " " + this.type : "") + "" + this.criterionEntries + (this.orderEntries.isEmpty() ? "" : " order by " + this.orderEntries);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractCriteriaImpl)) {
            return false;
        }
        AbstractCriteriaImpl other = (AbstractCriteriaImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.firstResult != other.firstResult) {
            return false;
        }
        if (this.forcePagingWithDocumentOrder != other.forcePagingWithDocumentOrder) {
            return false;
        }
        Integer this$maxResults = this.maxResults;
        Integer other$maxResults = other.maxResults;
        if (this$maxResults == null ? other$maxResults != null : !((Object)this$maxResults).equals(other$maxResults)) {
            return false;
        }
        String this$basePath = this.basePath;
        String other$basePath = other.basePath;
        if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<TranslatableCriteria.CriterionEntry> this$criterionEntries = this.criterionEntries;
        List<TranslatableCriteria.CriterionEntry> other$criterionEntries = other.criterionEntries;
        if (this$criterionEntries == null ? other$criterionEntries != null : !((Object)this$criterionEntries).equals(other$criterionEntries)) {
            return false;
        }
        List<TranslatableCriteria.OrderEntry> this$orderEntries = this.orderEntries;
        List<TranslatableCriteria.OrderEntry> other$orderEntries = other.orderEntries;
        if (this$orderEntries == null ? other$orderEntries != null : !((Object)this$orderEntries).equals(other$orderEntries)) {
            return false;
        }
        List<Column> this$columns = this.columns;
        List<Column> other$columns = other.columns;
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        String this$spellCheckString = this.spellCheckString;
        String other$spellCheckString = other.spellCheckString;
        if (this$spellCheckString == null ? other$spellCheckString != null : !this$spellCheckString.equals(other$spellCheckString)) {
            return false;
        }
        String this$language = this.language;
        String other$language = other.language;
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        ZoneId this$timeZone = this.timeZone;
        ZoneId other$timeZone = other.timeZone;
        return !(this$timeZone == null ? other$timeZone != null : !((Object)this$timeZone).equals(other$timeZone));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractCriteriaImpl;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.firstResult;
        result = result * 59 + (this.forcePagingWithDocumentOrder ? 79 : 97);
        Integer $maxResults = this.maxResults;
        result = result * 59 + ($maxResults == null ? 43 : ((Object)$maxResults).hashCode());
        String $basePath = this.basePath;
        result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<TranslatableCriteria.CriterionEntry> $criterionEntries = this.criterionEntries;
        result = result * 59 + ($criterionEntries == null ? 43 : ((Object)$criterionEntries).hashCode());
        List<TranslatableCriteria.OrderEntry> $orderEntries = this.orderEntries;
        result = result * 59 + ($orderEntries == null ? 43 : ((Object)$orderEntries).hashCode());
        List<Column> $columns = this.columns;
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        String $spellCheckString = this.spellCheckString;
        result = result * 59 + ($spellCheckString == null ? 43 : $spellCheckString.hashCode());
        String $language = this.language;
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        ZoneId $timeZone = this.timeZone;
        result = result * 59 + ($timeZone == null ? 43 : ((Object)$timeZone).hashCode());
        return result;
    }

    @Generated
    public AbstractCriteriaImpl(String basePath, String type, List<TranslatableCriteria.CriterionEntry> criterionEntries, List<TranslatableCriteria.OrderEntry> orderEntries, List<Column> columns, Integer maxResults, int firstResult, String spellCheckString, boolean forcePagingWithDocumentOrder, String language, ZoneId timeZone) {
        this.basePath = basePath;
        this.type = type;
        this.criterionEntries = criterionEntries;
        this.orderEntries = orderEntries;
        this.columns = columns;
        this.maxResults = maxResults;
        this.firstResult = firstResult;
        this.spellCheckString = spellCheckString;
        this.forcePagingWithDocumentOrder = forcePagingWithDocumentOrder;
        this.language = language;
        this.timeZone = timeZone;
    }

    @Override
    @Generated
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public AbstractCriteriaImpl setType(String type) {
        this.type = type;
        return this;
    }

    @Generated
    public List<Column> getColumns() {
        return this.columns;
    }

    @Generated
    public Integer getMaxResults() {
        return this.maxResults;
    }

    @Override
    @Generated
    public AbstractCriteriaImpl setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Generated
    public int getFirstResult() {
        return this.firstResult;
    }

    @Override
    @Generated
    public AbstractCriteriaImpl setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    @Generated
    public String getSpellCheckString() {
        return this.spellCheckString;
    }

    @Override
    @Generated
    public AbstractCriteriaImpl setSpellCheckString(String spellCheckString) {
        this.spellCheckString = spellCheckString;
        return this;
    }

    @Generated
    public boolean isForcePagingWithDocumentOrder() {
        return this.forcePagingWithDocumentOrder;
    }

    @Override
    @Generated
    public AbstractCriteriaImpl setForcePagingWithDocumentOrder(boolean forcePagingWithDocumentOrder) {
        this.forcePagingWithDocumentOrder = forcePagingWithDocumentOrder;
        return this;
    }

    @Deprecated
    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Deprecated
    @Generated
    public AbstractCriteriaImpl setLanguage(String language) {
        this.language = language;
        return this;
    }

    @Override
    @Generated
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public AbstractCriteriaImpl setTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
        return this;
    }
}

