/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.criterion;

import java.util.Calendar;
import lombok.Generated;
import nl.vpro.jcr.criteria.query.Criteria;
import nl.vpro.jcr.criteria.query.JCRQueryException;
import nl.vpro.jcr.criteria.query.criterion.BaseCriterion;
import nl.vpro.jcr.criteria.query.criterion.Criterion;
import nl.vpro.jcr.criteria.query.criterion.Op;
import nl.vpro.jcr.criteria.query.sql2.Condition;
import nl.vpro.jcr.criteria.query.sql2.Field;
import nl.vpro.jcr.criteria.query.sql2.NotCondition;
import nl.vpro.jcr.criteria.query.sql2.SimpleExpressionCondition;
import nl.vpro.jcr.criteria.query.xpath.utils.XPathTextUtils;
import nl.vpro.jcr.utils.Utils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SimpleExpression
extends BaseCriterion
implements Criterion {
    private static final long serialVersionUID = -1104419394978535803L;
    private final String propertyName;
    private final Object value;
    private final Op op;

    protected SimpleExpression(@NonNull String propertyName, @NonNull Object value, @NonNull Op op) {
        this.propertyName = propertyName;
        this.value = value;
        this.op = op;
        if (this.op.getXpath() == null) {
            throw new IllegalArgumentException("" + (Object)((Object)op) + " cannot be used for " + this);
        }
    }

    public String toString() {
        return this.propertyName + (Object)((Object)this.getOp()) + this.value;
    }

    protected final Op getOp() {
        return this.op;
    }

    @Override
    public String toXPathString(Criteria criteria) throws JCRQueryException {
        StringBuilder fragment = new StringBuilder();
        Object v = Utils.toCalendarIfPossible(this.value, criteria.getTimeZone());
        if (v instanceof CharSequence) {
            fragment.append(this.propertyName).append((Object)this.getOp());
            String escValue = StringUtils.replace((String)((String)v), (String)"'", (String)"''");
            fragment.append("'").append(escValue).append("'");
        } else if (v instanceof Number) {
            fragment.append(this.propertyName).append((Object)this.getOp());
            fragment.append(v);
        } else if (v instanceof Character) {
            fragment.append(this.propertyName).append((Object)this.getOp());
            fragment.append("'").append(v).append("'");
        } else if (v instanceof Boolean) {
            fragment.append(this.propertyName).append((Object)this.getOp());
            fragment.append("'").append(v).append("'");
            if (this.getOp() == Op.NE) {
                fragment.append("or not(").append(this.propertyName).append(")");
            }
        } else if (v instanceof Calendar) {
            fragment.append(this.propertyName).append((Object)this.getOp());
            Calendar cal = (Calendar)v;
            fragment.append("xs:dateTime('").append(XPathTextUtils.toXsdDate(cal)).append("')");
        } else if (v != null) {
            fragment.append(this.propertyName).append((Object)this.getOp());
            fragment.append("'").append(v).append("'");
        }
        this.log.debug("xpathString is {} ", (Object)fragment);
        return fragment.toString();
    }

    @Override
    public Condition toSQLCondition(Criteria criteria) throws JCRQueryException {
        if (this.op == Op.NE) {
            return new NotCondition(SimpleExpressionCondition.of(Field.of(this.propertyName), Op.EQ, this.value, criteria.getTimeZone()));
        }
        return SimpleExpressionCondition.of(Field.of(this.propertyName), this.op, this.value, criteria.getTimeZone());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleExpression)) {
            return false;
        }
        SimpleExpression other = (SimpleExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$propertyName = this.propertyName;
        String other$propertyName = other.propertyName;
        if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
            return false;
        }
        Object this$value = this.value;
        Object other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Op this$op = this.getOp();
        Op other$op = other.getOp();
        return !(this$op == null ? other$op != null : !((Object)((Object)this$op)).equals((Object)other$op));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimpleExpression;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $propertyName = this.propertyName;
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        Object $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Op $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : ((Object)((Object)$op)).hashCode());
        return result;
    }
}

