/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.criterion;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.UUID;
import javax.jcr.Node;
import nl.vpro.jcr.criteria.query.criterion.BetweenExpression;
import nl.vpro.jcr.criteria.query.criterion.Conjunction;
import nl.vpro.jcr.criteria.query.criterion.ContainsExpression;
import nl.vpro.jcr.criteria.query.criterion.Criterion;
import nl.vpro.jcr.criteria.query.criterion.Disjunction;
import nl.vpro.jcr.criteria.query.criterion.InExpression;
import nl.vpro.jcr.criteria.query.criterion.IsChildOf;
import nl.vpro.jcr.criteria.query.criterion.IsDescendantOf;
import nl.vpro.jcr.criteria.query.criterion.IsNotNullExpression;
import nl.vpro.jcr.criteria.query.criterion.IsNullExpression;
import nl.vpro.jcr.criteria.query.criterion.IsSame;
import nl.vpro.jcr.criteria.query.criterion.JCRFunctionExpression;
import nl.vpro.jcr.criteria.query.criterion.LikeExpression;
import nl.vpro.jcr.criteria.query.criterion.MatchMode;
import nl.vpro.jcr.criteria.query.criterion.NotExpression;
import nl.vpro.jcr.criteria.query.criterion.Op;
import nl.vpro.jcr.criteria.query.criterion.SimpleExpression;
import nl.vpro.jcr.criteria.query.xpath.utils.XPathTextUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Restrictions {
    private Restrictions() {
    }

    public static @NonNull SimpleExpression eq(@NonNull String nodeName, @NonNull CharSequence value) {
        return new SimpleExpression(nodeName, value, Op.EQ);
    }

    public static @NonNull SimpleExpression eq(@NonNull String nodeName, @NonNull UUID value) {
        return new SimpleExpression(nodeName, value.toString(), Op.EQ);
    }

    public static @NonNull SimpleExpression eq(@NonNull String nodeName, @NonNull Number value) {
        return new SimpleExpression(nodeName, value, Op.EQ);
    }

    public static @NonNull SimpleExpression eq(@NonNull String nodeName, @NonNull Calendar value) {
        return new SimpleExpression(nodeName, value, Op.EQ);
    }

    public static @NonNull SimpleExpression eq(@NonNull String nodeName, @NonNull Instant value) {
        return new SimpleExpression(nodeName, value, Op.EQ);
    }

    public static @NonNull SimpleExpression eq(@NonNull String nodeName, @NonNull Boolean value) {
        return new SimpleExpression(nodeName, value, Op.EQ);
    }

    public static @NonNull SimpleExpression eq(@NonNull String nodeName, @NonNull LocalDateTime value) {
        return new SimpleExpression(nodeName, value, Op.EQ);
    }

    public static @NonNull SimpleExpression eq(@NonNull String nodeName, @NonNull LocalDate value) {
        return new SimpleExpression(nodeName, value, Op.EQ);
    }

    public static @NonNull SimpleExpression attrEq(@NonNull String attName, @NonNull CharSequence value) {
        return Restrictions.eq(Restrictions.attr(attName), value);
    }

    public static @NonNull SimpleExpression attrEq(@NonNull String nodeName, @NonNull UUID value) {
        return Restrictions.eq(Restrictions.attr(nodeName), value);
    }

    public static @NonNull SimpleExpression attrEq(@NonNull String attName, @NonNull Number value) {
        return Restrictions.eq(Restrictions.attr(attName), value);
    }

    public static @NonNull SimpleExpression attrEq(@NonNull String attName, @NonNull Boolean value) {
        return Restrictions.eq(Restrictions.attr(attName), value);
    }

    public static @NonNull SimpleExpression attrEq(@NonNull String attName, @NonNull Calendar value) {
        return Restrictions.eq(Restrictions.attr(attName), value);
    }

    public static @NonNull SimpleExpression attrEq(@NonNull String attName, @NonNull Instant value) {
        return Restrictions.eq(Restrictions.attr(attName), value);
    }

    public static @NonNull SimpleExpression attrEq(@NonNull String attName, @NonNull LocalDateTime value) {
        return Restrictions.eq(Restrictions.attr(attName), value);
    }

    public static @NonNull SimpleExpression attrEq(@NonNull String nodeName, @NonNull LocalDate value) {
        return Restrictions.eq(Restrictions.attr(nodeName), value);
    }

    public static @NonNull Criterion has(@NonNull String name) {
        return Restrictions.isNotNull(name);
    }

    public static @NonNull Criterion hasnt(@NonNull String name) {
        return Restrictions.isNull(name);
    }

    public static @NonNull SimpleExpression isTrue(@NonNull String name) {
        return Restrictions.eq(name, Boolean.TRUE);
    }

    public static @NonNull SimpleExpression attrIsTrue(@NonNull String name) {
        return Restrictions.isTrue(Restrictions.attr(name));
    }

    public static @NonNull Criterion isFalsy(@NonNull String name) {
        return Restrictions.or(Restrictions.eq(name, Boolean.FALSE), Restrictions.hasnt(name));
    }

    public static @NonNull Criterion attrIsFalsy(@NonNull String name) {
        return Restrictions.isFalsy(Restrictions.attr(name));
    }

    public static SimpleExpression op(@NonNull Op op, @NonNull String nodeName, @NonNull Object value) {
        return new SimpleExpression(nodeName, value, op);
    }

    public static @NonNull SimpleExpression attrOp(@NonNull Op op, @NonNull String attrName, @NonNull Object value) {
        return Restrictions.op(op, Restrictions.attr(attrName), value);
    }

    public static @NonNull SimpleExpression ne(@NonNull String nodeName, @NonNull CharSequence value) {
        return new SimpleExpression(nodeName, value, Op.NE);
    }

    public static @NonNull SimpleExpression ne(@NonNull String nodeName, @NonNull Number value) {
        return new SimpleExpression(nodeName, value, Op.NE);
    }

    public static @NonNull SimpleExpression ne(@NonNull String nodeName, @NonNull Calendar value) {
        return new SimpleExpression(nodeName, value, Op.NE);
    }

    public static @NonNull SimpleExpression ne(@NonNull String nodeName, @NonNull Instant value) {
        return new SimpleExpression(nodeName, value, Op.NE);
    }

    public static @NonNull SimpleExpression ne(@NonNull String nodeName, @NonNull LocalDateTime value) {
        return new SimpleExpression(nodeName, value, Op.NE);
    }

    public static @NonNull SimpleExpression ne(@NonNull String nodeName, @NonNull Boolean value) {
        return new SimpleExpression(nodeName, value, Op.NE);
    }

    public static @NonNull JCRFunctionExpression like(@NonNull String nodeName, @NonNull CharSequence value) {
        return Restrictions.like(nodeName, value, MatchMode.ANYWHERE);
    }

    public static @NonNull JCRFunctionExpression like(@NonNull String nodeName, @NonNull CharSequence value, @NonNull MatchMode matchMode) {
        return new LikeExpression(nodeName, XPathTextUtils.stringToJCRSearchExp(value.toString()), " jcr:like", matchMode);
    }

    public static @NonNull JCRFunctionExpression attrLike(@NonNull String attName, @NonNull CharSequence value) {
        return Restrictions.like(Restrictions.attr(attName), value);
    }

    public static @NonNull JCRFunctionExpression attrLike(@NonNull String attName, @NonNull CharSequence value, @NonNull MatchMode matchMode) {
        return Restrictions.like(Restrictions.attr(attName), value, matchMode);
    }

    @Deprecated
    public static @NonNull JCRFunctionExpression contains(@NonNull String nodeName, @NonNull CharSequence value, boolean escape) {
        CharSequence exp = escape ? XPathTextUtils.stringToJCRSearchExp(value.toString()) : value;
        return new JCRFunctionExpression(nodeName, exp, " jcr:contains");
    }

    public static Criterion contains(@NonNull String nodeName, @NonNull CharSequence value) {
        return new ContainsExpression(nodeName, value);
    }

    public static @NonNull SimpleExpression gt(@NonNull String nodeName, @NonNull CharSequence value) {
        return new SimpleExpression(nodeName, value, Op.GT);
    }

    public static @NonNull SimpleExpression gt(@NonNull String nodeName, @NonNull Number value) {
        return new SimpleExpression(nodeName, value, Op.GT);
    }

    public static @NonNull SimpleExpression gt(@NonNull String nodeName, @NonNull Calendar value) {
        return new SimpleExpression(nodeName, value, Op.GT);
    }

    public static @NonNull SimpleExpression gt(@NonNull String nodeName, @NonNull LocalDateTime value) {
        return new SimpleExpression(nodeName, value, Op.GT);
    }

    public static @NonNull SimpleExpression lt(@NonNull String nodeName, @NonNull CharSequence value) {
        return new SimpleExpression(nodeName, value, Op.LT);
    }

    public static @NonNull SimpleExpression lt(@NonNull String nodeName, @NonNull Number value) {
        return new SimpleExpression(nodeName, value, Op.LT);
    }

    public static @NonNull SimpleExpression lt(@NonNull String nodeName, @NonNull Calendar value) {
        return new SimpleExpression(nodeName, value, Op.LT);
    }

    public static @NonNull SimpleExpression lt(@NonNull String nodeName, @NonNull LocalDateTime value) {
        return new SimpleExpression(nodeName, value, Op.LT);
    }

    public static @NonNull SimpleExpression le(@NonNull String nodeName, @NonNull CharSequence value) {
        return new SimpleExpression(nodeName, value, Op.LE);
    }

    public static @NonNull SimpleExpression le(@NonNull String nodeName, @NonNull Number value) {
        return new SimpleExpression(nodeName, value, Op.LE);
    }

    public static @NonNull SimpleExpression le(@NonNull String nodeName, @NonNull Calendar value) {
        return new SimpleExpression(nodeName, value, Op.LE);
    }

    public static @NonNull SimpleExpression le(@NonNull String nodeName, @NonNull LocalDateTime value) {
        return new SimpleExpression(nodeName, value, Op.LE);
    }

    public static @NonNull SimpleExpression ge(@NonNull String nodeName, @NonNull CharSequence value) {
        return new SimpleExpression(nodeName, value, Op.GE);
    }

    public static @NonNull SimpleExpression ge(String nodeName, Number value) {
        return new SimpleExpression(nodeName, value, Op.GE);
    }

    public static @NonNull SimpleExpression ge(String nodeName, Calendar value) {
        return new SimpleExpression(nodeName, value, Op.GE);
    }

    public static @NonNull SimpleExpression ge(String nodeName, LocalDateTime value) {
        return new SimpleExpression(nodeName, value, Op.GE);
    }

    public static @NonNull Criterion between(String nodeName, CharSequence lo, CharSequence hi) {
        return Restrictions.between(nodeName, lo, true, hi, true);
    }

    public static @NonNull Criterion between(String nodeName, CharSequence lo, boolean lowerInclusive, CharSequence hi, boolean higherInclusive) {
        return new BetweenExpression(nodeName, (Comparable<?>)((Object)lo.toString()), lowerInclusive, (Comparable<?>)((Object)hi.toString()), higherInclusive);
    }

    public static @NonNull Criterion between(String nodeName, Number lo, Number hi) {
        return Restrictions.between(nodeName, lo, true, hi, true);
    }

    public static @NonNull Criterion between(String nodeName, Number lo, boolean lowerInclusive, Number hi, boolean higherInclusive) {
        return new BetweenExpression(nodeName, (Comparable)((Object)lo), lowerInclusive, (Comparable)((Object)hi), higherInclusive);
    }

    public static @NonNull Criterion between(String nodeName, Calendar lo, Calendar hi) {
        return Restrictions.between(nodeName, lo, true, hi, true);
    }

    public static @NonNull Criterion between(String nodeName, Calendar lo, boolean lowerInclusive, Calendar hi, boolean higherInclusive) {
        return new BetweenExpression(nodeName, lo, lowerInclusive, hi, higherInclusive);
    }

    public static @NonNull Criterion between(String nodeName, LocalDateTime lo, LocalDateTime hi) {
        return Restrictions.between(nodeName, lo, true, hi, true);
    }

    public static @NonNull Criterion between(String nodeName, LocalDateTime lo, boolean lowerInclusive, LocalDateTime hi, boolean higherInclusive) {
        return new BetweenExpression(nodeName, lo, lowerInclusive, hi, higherInclusive);
    }

    public static @NonNull Criterion between(String nodeName, LocalDate lo, LocalDate hi) {
        return Restrictions.between(nodeName, lo, true, hi, true);
    }

    public static @NonNull Criterion between(String nodeName, LocalDate lo, boolean lowerInclusive, LocalDate hi, boolean higherInclusive) {
        return new BetweenExpression(nodeName, lo, lowerInclusive, hi, higherInclusive);
    }

    public static @NonNull Criterion between(String nodeName, Instant lo, Instant hi) {
        return Restrictions.between(nodeName, lo, true, hi, true);
    }

    public static @NonNull Criterion between(String nodeName, Instant lo, boolean lowerInclusive, Instant hi, boolean higherInclusive) {
        return new BetweenExpression(nodeName, lo, lowerInclusive, hi, higherInclusive);
    }

    public static @NonNull Criterion eqDate(String nodeName, Calendar value) {
        return Restrictions.betweenDates(nodeName, value, value);
    }

    public static @NonNull Criterion eqDate(String nodeName, LocalDate value) {
        return Restrictions.between(nodeName, value, value);
    }

    public static @NonNull Criterion betweenDates(String nodeName, Calendar lo, Calendar hi) {
        return Restrictions.between(nodeName, Restrictions.getDayStart(lo), Restrictions.getDayEnd(hi));
    }

    public static @NonNull Criterion in(String nodeName, String ... values) {
        return new InExpression(nodeName, values);
    }

    public static @NonNull Criterion in(UUID ... values) {
        return new InExpression("jcr:uuid", (CharSequence[])Arrays.stream(values).map(UUID::toString).toArray(String[]::new), false);
    }

    public static @NonNull Criterion in(Collection<UUID> values) {
        return new InExpression("jcr:uuid", (CharSequence[])values.stream().map(UUID::toString).toArray(String[]::new), false);
    }

    public static @NonNull Criterion in(String nodeName, Collection<String> values) {
        return new InExpression(nodeName, values.toArray(new String[0]));
    }

    public static @NonNull Criterion isNull(String nodeName) {
        return new IsNullExpression(nodeName);
    }

    public static @NonNull Criterion isNotNull(String nodeName) {
        return new IsNotNullExpression(nodeName);
    }

    public static @NonNull Conjunction and(Criterion ... clauses) {
        return new Conjunction(true, clauses);
    }

    public static @NonNull Disjunction or(Criterion ... clauses) {
        return new Disjunction(true, clauses);
    }

    public static @NonNull Criterion not(Criterion expression) {
        return new NotExpression(expression);
    }

    public static @NonNull Criterion hasNodeType(String ... nodetypes) {
        return new InExpression("@jcr:primaryType", nodetypes, false);
    }

    @Deprecated
    public static @NonNull Conjunction conjunction() {
        return new Conjunction(true, new Criterion[0]);
    }

    @Deprecated
    public static @NonNull Disjunction disjunction() {
        return new Disjunction(true, new Criterion[0]);
    }

    public static @NonNull String attr(@NonNull String attName) {
        return '@' + attName;
    }

    private static Calendar getDayStart(Calendar cal) {
        Calendar cal2 = Calendar.getInstance();
        cal2.clear();
        cal2.set(cal.get(1), cal.get(2), cal.get(5));
        return cal2;
    }

    private static Calendar getDayEnd(Calendar cal) {
        Calendar cal2 = Restrictions.getDayStart(cal);
        cal2.add(6, 1);
        cal2.add(14, -1);
        return cal2;
    }

    public static Criterion isDescendantOf(Node issueNode) {
        return Restrictions.isDescendantOf(issueNode.getPath());
    }

    public static Criterion isDescendantOf(String path) {
        return new IsDescendantOf(path);
    }

    public static Criterion isSame(String path) {
        return new IsSame(path);
    }

    public static Criterion isSame(Node node) {
        return Restrictions.isSame(node.getPath());
    }

    public static Criterion isChildOf(Node issueNode) {
        return Restrictions.isChildOf(issueNode.getPath());
    }

    public static Criterion isChildOf(String path) {
        return new IsChildOf(path);
    }
}

