/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.criterion;

import lombok.Generated;
import nl.vpro.jcr.criteria.query.Criteria;
import nl.vpro.jcr.criteria.query.JCRQueryException;
import nl.vpro.jcr.criteria.query.criterion.JCRFunctionExpression;
import nl.vpro.jcr.criteria.query.criterion.MatchMode;
import nl.vpro.jcr.criteria.query.sql2.Condition;
import nl.vpro.jcr.criteria.query.sql2.LikeCondition;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LikeExpression
extends JCRFunctionExpression {
    private static final long serialVersionUID = 1810624472706401714L;
    private final MatchMode matchMode;

    public LikeExpression(@NonNull String propertyName, @NonNull CharSequence value, @NonNull String function, @Nullable MatchMode matchMode) {
        super(propertyName, value, function);
        if (matchMode == null) {
            matchMode = MatchMode.NONE;
        }
        this.matchMode = matchMode;
    }

    @Override
    public String toXPathString(Criteria criteria) throws JCRQueryException {
        StringBuilder fragment = new StringBuilder();
        fragment.append(" (").append(this.function).append("(");
        fragment.append(this.propertyName);
        fragment.append(", '").append(this.matchMode.toMatchString(this.value.toString())).append("') ) ");
        this.log.debug("xpathString is {} ", (Object)fragment);
        return fragment.toString();
    }

    @Override
    public Condition toSQLCondition(Criteria criteria) {
        return new LikeCondition(this.propertyName, this.matchMode.toMatchString(this.value.toString()));
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LikeExpression)) {
            return false;
        }
        LikeExpression other = (LikeExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MatchMode this$matchMode = this.matchMode;
        MatchMode other$matchMode = other.matchMode;
        return !(this$matchMode == null ? other$matchMode != null : !((Object)((Object)this$matchMode)).equals((Object)other$matchMode));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LikeExpression;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MatchMode $matchMode = this.matchMode;
        result = result * 59 + ($matchMode == null ? 43 : ((Object)((Object)$matchMode)).hashCode());
        return result;
    }
}

