/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.criterion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import nl.vpro.jcr.criteria.query.Criteria;
import nl.vpro.jcr.criteria.query.JCRQueryException;
import nl.vpro.jcr.criteria.query.criterion.Criterion;
import nl.vpro.jcr.criteria.query.sql2.BooleanCondition;
import org.apache.commons.lang3.StringUtils;

public abstract class Junction
implements Criterion {
    private static final long serialVersionUID = 4745761472724863693L;
    final List<Criterion> criteria = new ArrayList<Criterion>();
    final String op;
    boolean outer;

    protected Junction(String op, boolean outer, Criterion ... clauses) {
        this.op = op;
        this.outer = outer;
        this.criteria.addAll(Arrays.asList(clauses));
    }

    public Junction add(Criterion criterion) {
        this.criteria.add(criterion);
        return this;
    }

    @Override
    public String toXPathString(Criteria crit) throws JCRQueryException {
        if (this.criteria.size() == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        if (this.criteria.size() > 1) {
            buffer.append('(');
        }
        Iterator<Criterion> iter = this.criteria.iterator();
        boolean isfirst = true;
        while (iter.hasNext()) {
            Criterion next = iter.next();
            String xPathString = next.toXPathString(crit);
            if (!StringUtils.isNotBlank((CharSequence)xPathString)) continue;
            if (!isfirst) {
                buffer.append(' ').append(this.op).append(' ');
            }
            buffer.append(xPathString);
            isfirst = false;
        }
        if (this.criteria.size() > 1) {
            buffer.append(')');
        }
        return buffer.toString();
    }

    @Override
    public BooleanCondition toSQLCondition(Criteria c) {
        BooleanCondition result = this.createCondition();
        for (Criterion clause : this.criteria) {
            result.getClauses().add(clause.toSQLCondition(c));
        }
        return result;
    }

    abstract BooleanCondition createCondition();

    public String toString() {
        return '(' + StringUtils.join(this.criteria.iterator(), (String)(' ' + this.op + ' ')) + ')';
    }

    public boolean isEmpty() {
        return this.criteria.isEmpty();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Junction)) {
            return false;
        }
        Junction other = (Junction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOuter() != other.isOuter()) {
            return false;
        }
        List<Criterion> this$criteria = this.criteria;
        List<Criterion> other$criteria = other.criteria;
        if (this$criteria == null ? other$criteria != null : !((Object)this$criteria).equals(other$criteria)) {
            return false;
        }
        String this$op = this.getOp();
        String other$op = other.getOp();
        return !(this$op == null ? other$op != null : !this$op.equals(other$op));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Junction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOuter() ? 79 : 97);
        List<Criterion> $criteria = this.criteria;
        result = result * 59 + ($criteria == null ? 43 : ((Object)$criteria).hashCode());
        String $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : $op.hashCode());
        return result;
    }

    @Generated
    String getOp() {
        return this.op;
    }

    @Generated
    public boolean isOuter() {
        return this.outer;
    }

    @Generated
    public void setOuter(boolean outer) {
        this.outer = outer;
    }
}

