/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.criterion;

import java.time.ZoneId;
import java.util.Arrays;
import lombok.Generated;
import nl.vpro.jcr.criteria.query.Criteria;
import nl.vpro.jcr.criteria.query.JCRQueryException;
import nl.vpro.jcr.criteria.query.criterion.Criterion;
import nl.vpro.jcr.criteria.query.criterion.Op;
import nl.vpro.jcr.criteria.query.criterion.Restrictions;
import nl.vpro.jcr.criteria.query.sql2.Condition;
import nl.vpro.jcr.criteria.query.sql2.ContainsCondition;
import nl.vpro.jcr.criteria.query.sql2.Field;
import nl.vpro.jcr.criteria.query.sql2.OrCondition;
import nl.vpro.jcr.criteria.query.sql2.SimpleExpressionCondition;

public class InExpression
implements Criterion {
    private static final long serialVersionUID = -8445602953808764036L;
    private final String nodeName;
    private final CharSequence[] values;
    private final boolean useContains;

    public InExpression(String nodeName, CharSequence[] values, boolean useContains) {
        this.nodeName = nodeName;
        this.values = values;
        this.useContains = useContains;
    }

    public InExpression(String nodeName, CharSequence[] values) {
        this(nodeName, values, true);
    }

    @Override
    public String toXPathString(Criteria criteria) throws JCRQueryException {
        StringBuilder inClause = new StringBuilder("( ");
        for (int i = 0; i < this.values.length; ++i) {
            String predicate = this.useContains ? Restrictions.contains(this.nodeName, this.values[i]).toXPathString(criteria) : Restrictions.eq(this.nodeName, this.values[i]).toXPathString(criteria);
            inClause.append(predicate);
            if (i + 1 == this.values.length) continue;
            inClause.append(" or ");
        }
        inClause.append(") ");
        return inClause.toString();
    }

    @Override
    public Condition toSQLCondition(Criteria criteria) {
        if (this.values.length == 1) {
            return this.toSQLCondition(this.values[0], criteria.getTimeZone());
        }
        OrCondition orCondition = new OrCondition(new Condition[0]);
        for (CharSequence cs : this.values) {
            orCondition.getClauses().add(this.toSQLCondition(cs, criteria.getTimeZone()));
        }
        return orCondition;
    }

    protected Condition toSQLCondition(CharSequence cs, ZoneId zoneId) {
        if (this.useContains) {
            return new ContainsCondition(this.nodeName, cs.toString());
        }
        return SimpleExpressionCondition.of(Field.of(this.nodeName), Op.EQ, cs, zoneId);
    }

    public String toString() {
        return this.nodeName + "in " + Arrays.asList(this.values);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InExpression)) {
            return false;
        }
        InExpression other = (InExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.useContains != other.useContains) {
            return false;
        }
        String this$nodeName = this.nodeName;
        String other$nodeName = other.nodeName;
        if (this$nodeName == null ? other$nodeName != null : !this$nodeName.equals(other$nodeName)) {
            return false;
        }
        return Arrays.deepEquals(this.values, other.values);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InExpression;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.useContains ? 79 : 97);
        String $nodeName = this.nodeName;
        result = result * 59 + ($nodeName == null ? 43 : $nodeName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.values);
        return result;
    }
}

