/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.criterion;

import lombok.Generated;
import nl.vpro.jcr.criteria.query.Criteria;
import nl.vpro.jcr.criteria.query.JCRQueryException;
import nl.vpro.jcr.criteria.query.criterion.BaseCriterion;
import nl.vpro.jcr.criteria.query.sql2.Condition;
import nl.vpro.jcr.criteria.query.sql2.ContainsCondition;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ContainsExpression
extends BaseCriterion {
    private static final long serialVersionUID = 0L;
    private final String propertyName;
    private final CharSequence value;

    public ContainsExpression(@NonNull String propertyName, @NonNull CharSequence value) {
        this.propertyName = propertyName;
        this.value = value;
    }

    @Override
    public String toXPathString(Criteria criteria) throws JCRQueryException {
        StringBuilder fragment = new StringBuilder();
        fragment.append(" (").append("jcr:contains").append("(").append(this.propertyName).append(", '").append(this.value).append("') ) ");
        this.log.debug("xpathString is {} ", (Object)fragment);
        return fragment.toString();
    }

    @Override
    public Condition toSQLCondition(Criteria criteria) {
        return new ContainsCondition(this.propertyName, this.value);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainsExpression)) {
            return false;
        }
        ContainsExpression other = (ContainsExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$propertyName = this.propertyName;
        String other$propertyName = other.propertyName;
        if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
            return false;
        }
        CharSequence this$value = this.value;
        CharSequence other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContainsExpression;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $propertyName = this.propertyName;
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        CharSequence $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

