/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query.criterion;

import java.util.Calendar;
import lombok.Generated;
import lombok.NonNull;
import nl.vpro.jcr.criteria.query.Criteria;
import nl.vpro.jcr.criteria.query.JCRQueryException;
import nl.vpro.jcr.criteria.query.criterion.BaseCriterion;
import nl.vpro.jcr.criteria.query.criterion.Criterion;
import nl.vpro.jcr.criteria.query.criterion.Op;
import nl.vpro.jcr.criteria.query.sql2.AndCondition;
import nl.vpro.jcr.criteria.query.sql2.Condition;
import nl.vpro.jcr.criteria.query.sql2.Field;
import nl.vpro.jcr.criteria.query.sql2.SimpleExpressionCondition;
import nl.vpro.jcr.criteria.query.xpath.utils.XPathTextUtils;
import nl.vpro.jcr.utils.Utils;

public class BetweenExpression
extends BaseCriterion
implements Criterion {
    private static final long serialVersionUID = 6686395240415024541L;
    private final String propertyName;
    private final Comparable<?> lo;
    private final boolean lowerInclusive;
    private final Comparable<?> hi;
    private final boolean higherInclusive;

    protected BetweenExpression(@NonNull String propertyName, @NonNull Comparable<?> lo, boolean lowerInclusive, @NonNull Comparable<?> hi, boolean higherInclusive) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName is marked non-null but is null");
        }
        if (lo == null) {
            throw new NullPointerException("lo is marked non-null but is null");
        }
        if (hi == null) {
            throw new NullPointerException("hi is marked non-null but is null");
        }
        this.propertyName = propertyName;
        this.lo = lo;
        this.lowerInclusive = lowerInclusive;
        this.hi = hi;
        this.higherInclusive = higherInclusive;
    }

    public String toString() {
        return this.propertyName + " between " + (this.lowerInclusive ? "[" : "<") + this.lo + ", " + this.hi + (this.higherInclusive ? "]" : ">");
    }

    @Override
    public String toXPathString(Criteria criteria) throws JCRQueryException {
        StringBuilder fragment = new StringBuilder();
        fragment.append(" (").append(this.propertyName).append(this.lowerOp().getXpath());
        Object v1 = Utils.toCalendarIfPossible(this.lo, criteria.getTimeZone());
        Object v2 = Utils.toCalendarIfPossible(this.hi, criteria.getTimeZone());
        if (v1 instanceof CharSequence && v2 instanceof CharSequence) {
            fragment.append('\'').append(v1).append("' and ").append(this.propertyName).append(this.higherOp().getXpath()).append('\'').append(v2).append('\'');
        } else if (v1 instanceof Number && v2 instanceof Number) {
            fragment.append(v1).append(" and ").append(this.propertyName).append(this.higherOp().getXpath()).append(v2);
        } else if (v1 instanceof Calendar && v2 instanceof Calendar) {
            Calendar cal1 = (Calendar)v1;
            Calendar cal2 = (Calendar)v2;
            this.toXPathString(fragment, cal1, cal2);
        } else {
            throw new IllegalArgumentException("values provided are not of the accepted types String, Number, Calendar (they are  " + this.lo.getClass() + ", " + this.hi.getClass() + ")");
        }
        fragment.append(")");
        this.log.debug("xpathString is {} ", (Object)fragment);
        return fragment.toString();
    }

    protected void toXPathString(StringBuilder fragment, Calendar cal1, Calendar cal2) {
        fragment.append("xs:dateTime('").append(XPathTextUtils.toXsdDate(cal1)).append("')  and ").append(this.propertyName).append(this.higherOp().getXpath()).append("xs:dateTime").append("('").append(XPathTextUtils.toXsdDate(cal2)).append("') ");
    }

    @Override
    public Condition toSQLCondition(Criteria criteria) {
        return new AndCondition(SimpleExpressionCondition.of(Field.of(this.propertyName), this.lowerOp(), this.lo, criteria.getTimeZone()), SimpleExpressionCondition.of(Field.of(this.propertyName), this.higherOp(), this.hi, criteria.getTimeZone()));
    }

    protected Op lowerOp() {
        return this.lowerInclusive ? Op.GE : Op.GT;
    }

    protected Op higherOp() {
        return this.higherInclusive ? Op.LE : Op.LT;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BetweenExpression)) {
            return false;
        }
        BetweenExpression other = (BetweenExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.lowerInclusive != other.lowerInclusive) {
            return false;
        }
        if (this.higherInclusive != other.higherInclusive) {
            return false;
        }
        String this$propertyName = this.propertyName;
        String other$propertyName = other.propertyName;
        if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
            return false;
        }
        Comparable<?> this$lo = this.lo;
        Comparable<?> other$lo = other.lo;
        if (this$lo == null ? other$lo != null : !this$lo.equals(other$lo)) {
            return false;
        }
        Comparable<?> this$hi = this.hi;
        Comparable<?> other$hi = other.hi;
        return !(this$hi == null ? other$hi != null : !this$hi.equals(other$hi));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BetweenExpression;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.lowerInclusive ? 79 : 97);
        result = result * 59 + (this.higherInclusive ? 79 : 97);
        String $propertyName = this.propertyName;
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        Comparable<?> $lo = this.lo;
        result = result * 59 + ($lo == null ? 43 : $lo.hashCode());
        Comparable<?> $hi = this.hi;
        result = result * 59 + ($hi == null ? 43 : $hi.hashCode());
        return result;
    }
}

