/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query;

import javax.jcr.Session;
import nl.vpro.jcr.criteria.advanced.impl.QueryExecutorHelper;
import nl.vpro.jcr.criteria.query.AdvancedResult;
import nl.vpro.jcr.criteria.query.Criteria;
import nl.vpro.jcr.criteria.query.ExecutableQuery;

public class DirectJcrQuery
implements ExecutableQuery {
    private final Criteria.Expression expression;
    private String spellCheckString;
    private int maxResults;
    private int offset;

    public DirectJcrQuery(Criteria.Expression expression) {
        this.expression = expression;
    }

    public DirectJcrQuery setSpellCheckString(String spellCheckString) {
        this.spellCheckString = spellCheckString;
        return this;
    }

    public DirectJcrQuery setMaxResultsPerPage(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public DirectJcrQuery setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public DirectJcrQuery setPaging(int itemsPerPage, int pageNumberStartingFromOne) {
        return this.setMaxResultsPerPage(itemsPerPage).setOffset((Math.max(pageNumberStartingFromOne, 1) - 1) * this.maxResults);
    }

    @Override
    public AdvancedResult execute(Session session, String language) {
        if (language != null && !language.equals(this.expression.getLanguage())) {
            throw new IllegalArgumentException("This direct JCR criteria can only be executed as " + this.expression.getLanguage());
        }
        return QueryExecutorHelper.execute(this.expression, () -> {
            throw new UnsupportedOperationException();
        }, session, this.maxResults, this.offset, this.spellCheckString, false);
    }
}

