/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query;

import javax.jcr.Node;
import lombok.Generated;
import nl.vpro.jcr.criteria.query.ExecutableQuery;
import nl.vpro.jcr.criteria.query.criterion.Criterion;
import nl.vpro.jcr.criteria.query.criterion.Order;
import org.slf4j.LoggerFactory;

public interface Criteria
extends ExecutableQuery {
    public Criteria add(Criterion var1);

    public Criteria addOrder(Order var1);

    public Criteria addOrderByScore();

    public Criteria setMaxResults(Integer var1);

    public Criteria setFirstResult(int var1);

    public Criteria setBasePath(String var1);

    default public Criteria setBase(Node node) {
        return this.setBasePath(node.getPath());
    }

    public String getBasePath();

    default public Criteria setPaging(int itemsPerPage, int pageNumberStartingFromOne) {
        return this.setMaxResults(itemsPerPage).setFirstResult((Math.max(pageNumberStartingFromOne, 1) - 1) * itemsPerPage);
    }

    public Criteria setSpellCheckString(String var1);

    @Deprecated
    public Expression toXpathExpression();

    public Expression toSql2Expression();

    default public Expression toExpression() {
        return this.toExpression("");
    }

    default public Expression toExpression(String language) {
        if (language == null) {
            language = "";
        }
        switch (language) {
            case "xpath": {
                return this.toXpathExpression();
            }
            case "JCR-SQL2": {
                return this.toSql2Expression();
            }
            case "": {
                try {
                    return this.toSql2Expression();
                }
                catch (UnsupportedOperationException use) {
                    LoggerFactory.getLogger(this.getClass()).info(use.getMessage());
                    return this.toXpathExpression();
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported language " + language);
    }

    public Criteria setForcePagingWithDocumentOrder(boolean var1);

    public static class Expression {
        final String language;
        final String statement;

        private Expression(String language, String statement) {
            this.language = language;
            this.statement = statement;
        }

        public static Expression xpath(String statement) {
            return new Expression("xpath", statement);
        }

        public static Expression sql2(String statement) {
            return new Expression("JCR-SQL2", statement);
        }

        public String toString() {
            return this.language + ":\"" + this.statement + '\"';
        }

        @Generated
        public String getLanguage() {
            return this.language;
        }

        @Generated
        public String getStatement() {
            return this.statement;
        }
    }
}

