/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.query;

import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.query.Row;
import nl.vpro.jcr.criteria.advanced.impl.AdvancedResultItemImpl;
import nl.vpro.jcr.criteria.query.AdvancedResultItem;
import nl.vpro.jcr.criteria.query.ResultIterator;

public interface AdvancedResult
extends Iterable<AdvancedResultItem> {
    public static final AdvancedResult EMPTY_RESULT = new EmptyResult();

    public Integer getItemsPerPage();

    public int getPage();

    public long getTotalSize();

    public int getNumberOfPages();

    public String getSpellCheckerSuggestion();

    default public ResultIterator<AdvancedResultItem> getItems() {
        return this.getItems(AdvancedResultItemImpl::new);
    }

    public <K> ResultIterator<K> getItems(Function<Row, K> var1);

    public AdvancedResultItem getFirstResult();

    @Override
    default public ResultIterator<AdvancedResultItem> iterator() {
        return this.getItems();
    }

    default public Stream<AdvancedResultItem> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }

    public static final class EmptyResultIterator<K>
    implements ResultIterator<K> {
        public void skip(long skipNum) {
            if (skipNum > 0L) {
                throw new NoSuchElementException();
            }
        }

        public long getSize() {
            return 0L;
        }

        public long getPosition() {
            return 0L;
        }

        public boolean hasNext() {
            return false;
        }

        @Override
        public K next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    public static class EmptyResult
    implements AdvancedResult {
        @Override
        public long getTotalSize() {
            return 0L;
        }

        @Override
        public String getSpellCheckerSuggestion() {
            return null;
        }

        @Override
        public int getPage() {
            return 0;
        }

        @Override
        public Integer getItemsPerPage() {
            return null;
        }

        @Override
        public int getNumberOfPages() {
            return 0;
        }

        @Override
        public AdvancedResultItem getFirstResult() {
            return null;
        }

        @Override
        public <K> ResultIterator<K> getItems(Function<Row, K> wrapper) {
            return new EmptyResultIterator();
        }
    }
}

