/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.advanced.impl;

import java.util.function.LongSupplier;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import lombok.Generated;
import nl.vpro.jcr.criteria.advanced.impl.AdvancedResultImpl;
import nl.vpro.jcr.criteria.query.Criteria;
import nl.vpro.jcr.criteria.query.JCRQueryException;
import nl.vpro.jcr.criteria.query.xpath.utils.XPathTextUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueryExecutorHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryExecutorHelper.class);
    private static final ThreadLocal<Boolean> EXECUTING = ThreadLocal.withInitial(() -> Boolean.FALSE);

    private QueryExecutorHelper() {
    }

    public static AdvancedResultImpl execute(Criteria.Expression expression, LongSupplier queryCounter, Session jcrSession, Integer maxResults, int offset, String spellCheckString) {
        return QueryExecutorHelper.execute(expression, queryCounter, jcrSession, maxResults, offset, spellCheckString, false);
    }

    public static AdvancedResultImpl execute(Criteria.Expression expression, Session jcrSession, Integer maxResults, int offset, String spellCheckString) {
        return QueryExecutorHelper.execute(expression, jcrSession, maxResults, offset, spellCheckString, false);
    }

    public static AdvancedResultImpl execute(Criteria.Expression expression, Session jcrSession, Integer maxResults, int offset, String spellCheckString, boolean forcePagingWithDocumentOrder) {
        return QueryExecutorHelper.execute(expression, () -> {
            throw new UnsupportedOperationException();
        }, jcrSession, maxResults, offset, spellCheckString, forcePagingWithDocumentOrder);
    }

    public static AdvancedResultImpl execute(Criteria.Expression expr, LongSupplier queryCounter, Session jcrSession, Integer maxResults, int offset, String spellCheckString, boolean forcePagingWithDocumentOrder) {
        try {
            QueryManager jcrQueryManager = jcrSession.getWorkspace().getQueryManager();
            Query query = jcrQueryManager.createQuery(expr.getStatement(), expr.getLanguage());
            if (!forcePagingWithDocumentOrder) {
                if (maxResults != null && maxResults > 0) {
                    query.setLimit((long)maxResults.intValue());
                }
                if (offset > 0) {
                    query.setOffset((long)offset);
                }
            }
            int pageNumberStartingFromOne = 1;
            if (maxResults != null && maxResults > 0 && offset > maxResults - 1) {
                pageNumberStartingFromOne = offset / maxResults + 1;
            }
            Query spellCheckerQuery = null;
            if (StringUtils.isNotBlank((CharSequence)spellCheckString)) {
                spellCheckerQuery = jcrQueryManager.createQuery("/jcr:root[rep:spellcheck('" + XPathTextUtils.stringToJCRSearchExp(spellCheckString) + "')]/(rep:spellcheck())", "xpath");
            }
            log.debug("Executing {} {}", (Object)expr.getLanguage(), (Object)expr.getStatement());
            return new AdvancedResultImpl(() -> {
                try {
                    EXECUTING.set(Boolean.TRUE);
                    QueryResult queryResult = query.execute();
                    return queryResult;
                }
                catch (RepositoryException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    EXECUTING.set(Boolean.FALSE);
                }
            }, queryCounter, maxResults, pageNumberStartingFromOne, expr, spellCheckerQuery, forcePagingWithDocumentOrder, offset);
        }
        catch (RepositoryException e) {
            throw new JCRQueryException(expr, (Throwable)e);
        }
    }

    public static AdvancedResultImpl execute(Criteria.Expression expr, Session jcrSession) {
        return QueryExecutorHelper.execute(expr, null, jcrSession, null, 0, null, true);
    }

    public static boolean getExecuting() {
        return EXECUTING.get();
    }
}

