/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.advanced.impl;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import lombok.Generated;
import nl.vpro.jcr.criteria.query.AdvancedResultItem;
import nl.vpro.jcr.utils.JcrNodeWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedResultItemImpl
extends JcrNodeWrapper
implements AdvancedResultItem {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdvancedResultItemImpl.class);
    private final Row row;

    public AdvancedResultItemImpl(Row row) {
        this.row = row;
    }

    @Override
    public String getExcerpt(String selector) {
        Value excerptValue;
        try {
            excerptValue = this.row.getValue("rep:excerpt(" + selector + ")");
        }
        catch (RepositoryException e) {
            log.warn("Error getting excerpt for " + this.getHandle(), (Throwable)e);
            return null;
        }
        if (excerptValue != null) {
            try {
                return excerptValue.getString();
            }
            catch (RepositoryException e) {
                log.warn("Error getting excerpt for " + this.getHandle(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public double getScore() {
        try {
            return this.row.getScore();
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0.0;
        }
    }

    @Override
    public double getScore(String selector) {
        if (selector == null) {
            return this.getScore();
        }
        try {
            return this.row.getScore(selector);
        }
        catch (RepositoryException e) {
            log.warn("unable to extract score from {} using selector {}", (Object)this.row, (Object)selector);
            return 0.0;
        }
    }

    @Override
    protected Node getNode() {
        return this.row.getNode();
    }

    public String toString() {
        return "row:" + this.getHandle() + " " + this.getTitle();
    }
}

