/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.advanced.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import lombok.Generated;
import nl.vpro.jcr.criteria.query.AdvancedResult;
import nl.vpro.jcr.criteria.query.AdvancedResultItem;
import nl.vpro.jcr.criteria.query.Criteria;
import nl.vpro.jcr.criteria.query.JCRQueryException;
import nl.vpro.jcr.criteria.query.ResultIterator;
import nl.vpro.jcr.criteria.query.ResultIteratorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedResultImpl
implements AdvancedResult {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdvancedResultImpl.class);
    private static final String TOTAL_SIZE = "getTotalSize";
    private final Supplier<QueryResult> jcrQueryResult;
    private final LongSupplier queryCounter;
    private final Integer itemsPerPage;
    private final int pageNumberStartingFromOne;
    private final Criteria.Expression statement;
    private String spellCheckerSuggestion;
    private final Query spellCheckerQuery;
    private final boolean applyLocalPaging;
    private int offset;
    private Long totalResults;

    AdvancedResultImpl(Supplier<QueryResult> jcrQueryResult, LongSupplier queryCounter, Integer itemsPerPage, int pageNumberStartingFromOne, Criteria.Expression statement, Query spellCheckerQuery, boolean applyLocalPaging, int offset) {
        this.jcrQueryResult = jcrQueryResult;
        this.queryCounter = queryCounter;
        this.itemsPerPage = itemsPerPage;
        this.statement = statement;
        this.spellCheckerQuery = spellCheckerQuery;
        this.pageNumberStartingFromOne = pageNumberStartingFromOne;
        this.applyLocalPaging = applyLocalPaging;
        this.offset = offset;
    }

    @Override
    public Integer getItemsPerPage() {
        return this.itemsPerPage;
    }

    @Override
    public int getPage() {
        return this.pageNumberStartingFromOne;
    }

    @Override
    public long getTotalSize() {
        if (!this.totalSizeDetermined()) {
            long queryTotalSize = -1L;
            try {
                QueryResult queryResult = this.jcrQueryResult.get();
                Method m = queryResult.getClass().getMethod(TOTAL_SIZE, new Class[0]);
                queryTotalSize = ((Integer)m.invoke((Object)queryResult, new Object[0])).intValue();
                log.debug("Using  {}", (Object)m);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.debug("{}: {}", (Object)noSuchMethodException.getClass().getSimpleName(), (Object)noSuchMethodException.getMessage());
            }
            this.totalResults = queryTotalSize == -1L && (this.itemsPerPage == null || this.itemsPerPage == 0 || this.applyLocalPaging) ? Long.valueOf(this.getRowIterator().getSize()) : (queryTotalSize == -1L ? Long.valueOf(this.queryCounter.getAsLong()) : Long.valueOf(queryTotalSize));
            if (this.totalResults < 0L) {
                log.warn("Total results could not be determined");
            }
        }
        return this.totalResults;
    }

    boolean totalSizeDetermined() {
        return this.totalResults != null;
    }

    @Override
    public int getNumberOfPages() {
        return this.itemsPerPage > 0 ? (int)Math.round(Math.ceil((float)this.getTotalSize() / (float)this.itemsPerPage.intValue())) : 1;
    }

    @Override
    public <K> ResultIterator<K> getItems(Function<Row, K> wrapper) {
        if (this.applyLocalPaging && (this.itemsPerPage != null && this.itemsPerPage > 0 || this.offset > 0)) {
            if (this.offset == 0) {
                this.offset = (Math.max(this.pageNumberStartingFromOne, 1) - 1) * this.itemsPerPage;
            }
            RowIterator rowIterator = this.getRowIterator();
            rowIterator.skip((long)this.offset);
            return new ResultIteratorImpl<K>(rowIterator, wrapper){

                @Override
                public boolean hasNext() {
                    return super.getPosition() - (long)AdvancedResultImpl.this.offset < this.getSize() && super.hasNext();
                }

                @Override
                public long getSize() {
                    return Math.min(super.getSize() - (long)AdvancedResultImpl.this.offset, AdvancedResultImpl.this.itemsPerPage == null || AdvancedResultImpl.this.itemsPerPage == 0 ? super.getSize() : (long)AdvancedResultImpl.this.itemsPerPage.intValue());
                }
            };
        }
        return new ResultIteratorImpl<K>(this.getRowIterator(), wrapper);
    }

    protected RowIterator getRowIterator() {
        try {
            return this.jcrQueryResult.get().getRows();
        }
        catch (RepositoryException e) {
            throw new JCRQueryException(this.statement, (Throwable)e);
        }
    }

    @Override
    public String getSpellCheckerSuggestion() {
        if (this.spellCheckerSuggestion == null && this.spellCheckerQuery != null) {
            try {
                RowIterator rows = this.spellCheckerQuery.execute().getRows();
                Row r = rows.nextRow();
                Value v = r.getValue("rep:spellcheck()");
                if (v != null) {
                    this.spellCheckerSuggestion = v.getString();
                }
            }
            catch (RepositoryException e) {
                log.warn("Error getting excerpt using " + this.spellCheckerQuery.getStatement(), (Throwable)e);
                return null;
            }
        }
        return this.spellCheckerSuggestion;
    }

    @Override
    public AdvancedResultItem getFirstResult() {
        ResultIterator<AdvancedResultItem> items = this.getItems();
        if (items.hasNext()) {
            return items.next();
        }
        return null;
    }

    @Generated
    public String toString() {
        return "AdvancedResultImpl(jcrQueryResult=" + this.jcrQueryResult + ", queryCounter=" + this.queryCounter + ", itemsPerPage=" + this.getItemsPerPage() + ", pageNumberStartingFromOne=" + this.pageNumberStartingFromOne + ", statement=" + this.statement + ", spellCheckerSuggestion=" + this.getSpellCheckerSuggestion() + ", spellCheckerQuery=" + this.spellCheckerQuery + ", applyLocalPaging=" + this.applyLocalPaging + ", offset=" + this.offset + ", totalResults=" + this.totalResults + ")";
    }
}

