/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.jcr.criteria.advanced.impl;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.Min;
import lombok.Generated;
import nl.vpro.jcr.criteria.query.TranslatableCriteria;
import nl.vpro.jcr.criteria.query.criterion.Criterion;
import nl.vpro.jcr.criteria.query.criterion.Order;
import nl.vpro.jcr.criteria.query.impl.AbstractCriteriaImpl;
import nl.vpro.jcr.criteria.query.impl.Column;

public class AdvancedCriteriaImpl
extends AbstractCriteriaImpl {
    public AdvancedCriteriaImpl() {
    }

    private AdvancedCriteriaImpl(String basePath, String type, List<Criterion> criterions, List<Order> orders, Integer maxResults, int offset, String spellCheckString, boolean forcePagingWithDocumentOrder, @Deprecated String language, ZoneId timeZone, List<Column> columns) {
        super(basePath == null ? "//*" : basePath, type, null, null, columns == null ? Arrays.asList(Column.ALL) : columns, maxResults, offset, spellCheckString, forcePagingWithDocumentOrder, language, timeZone == null ? ZoneId.systemDefault() : timeZone);
        this.criterionEntries = criterions.stream().map(c -> new TranslatableCriteria.CriterionEntry((Criterion)c, this)).collect(Collectors.toList());
        this.orderEntries = orders.stream().map(o -> new TranslatableCriteria.OrderEntry((Order)o, this)).collect(Collectors.toList());
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvancedCriteriaImpl)) {
            return false;
        }
        AdvancedCriteriaImpl other = (AdvancedCriteriaImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdvancedCriteriaImpl;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class Builder {
        @Generated
        private String basePath;
        @Generated
        private String type;
        @Generated
        private ArrayList<Criterion> criterions;
        @Generated
        private ArrayList<Order> orders;
        @Generated
        private Integer maxResults;
        @Generated
        private int offset;
        @Generated
        private String spellCheckString;
        @Generated
        private boolean forcePagingWithDocumentOrder;
        @Generated
        private String language;
        @Generated
        private ZoneId timeZone;
        @Generated
        private ArrayList<Column> columns;

        public Builder paging(@Min(value=1L) @Min(value=1L) int pageSize, @Min(value=1L) @Min(value=1L) int pageNumber) {
            return this.offset((Math.max(pageNumber, 1) - 1) * pageSize).maxResults(pageSize);
        }

        public Builder add(Criterion criterion) {
            return this.criterion(criterion);
        }

        public Builder add(Order order) {
            return this.order(order);
        }

        public Builder fromUnstructured() {
            return this.from("{http://www.jcp.org/jcr/nt/1.0}unstructured");
        }

        public Builder from(String type) {
            return this.type(type);
        }

        public Builder asc(String field) {
            return this.order(Order.asc(field));
        }

        public Builder desc(String field) {
            return this.order(Order.desc(field));
        }

        public Builder score() {
            return this.order(Order.SCORE);
        }

        @Generated
        Builder() {
        }

        @Generated
        public Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Generated
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public Builder criterion(Criterion criterion) {
            if (this.criterions == null) {
                this.criterions = new ArrayList();
            }
            this.criterions.add(criterion);
            return this;
        }

        @Generated
        public Builder criterions(Collection<? extends Criterion> criterions) {
            if (criterions == null) {
                throw new NullPointerException("criterions cannot be null");
            }
            if (this.criterions == null) {
                this.criterions = new ArrayList();
            }
            this.criterions.addAll(criterions);
            return this;
        }

        @Generated
        public Builder clearCriterions() {
            if (this.criterions != null) {
                this.criterions.clear();
            }
            return this;
        }

        @Generated
        public Builder order(Order order) {
            if (this.orders == null) {
                this.orders = new ArrayList();
            }
            this.orders.add(order);
            return this;
        }

        @Generated
        public Builder orders(Collection<? extends Order> orders) {
            if (orders == null) {
                throw new NullPointerException("orders cannot be null");
            }
            if (this.orders == null) {
                this.orders = new ArrayList();
            }
            this.orders.addAll(orders);
            return this;
        }

        @Generated
        public Builder clearOrders() {
            if (this.orders != null) {
                this.orders.clear();
            }
            return this;
        }

        @Generated
        public Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Generated
        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public Builder spellCheckString(String spellCheckString) {
            this.spellCheckString = spellCheckString;
            return this;
        }

        @Generated
        public Builder forcePagingWithDocumentOrder(boolean forcePagingWithDocumentOrder) {
            this.forcePagingWithDocumentOrder = forcePagingWithDocumentOrder;
            return this;
        }

        @Deprecated
        @Generated
        public Builder language(String language) {
            this.language = language;
            return this;
        }

        @Generated
        public Builder timeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        @Generated
        public Builder column(Column column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return this;
        }

        @Generated
        public Builder columns(Collection<? extends Column> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return this;
        }

        @Generated
        public Builder clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return this;
        }

        @Generated
        public AdvancedCriteriaImpl build() {
            List<Object> columns;
            List<Object> orders;
            List<Object> criterions;
            switch (this.criterions == null ? 0 : this.criterions.size()) {
                case 0: {
                    criterions = Collections.emptyList();
                    break;
                }
                case 1: {
                    criterions = Collections.singletonList(this.criterions.get(0));
                    break;
                }
                default: {
                    criterions = Collections.unmodifiableList(new ArrayList<Criterion>(this.criterions));
                }
            }
            switch (this.orders == null ? 0 : this.orders.size()) {
                case 0: {
                    orders = Collections.emptyList();
                    break;
                }
                case 1: {
                    orders = Collections.singletonList(this.orders.get(0));
                    break;
                }
                default: {
                    orders = Collections.unmodifiableList(new ArrayList<Order>(this.orders));
                }
            }
            switch (this.columns == null ? 0 : this.columns.size()) {
                case 0: {
                    columns = Collections.emptyList();
                    break;
                }
                case 1: {
                    columns = Collections.singletonList(this.columns.get(0));
                    break;
                }
                default: {
                    columns = Collections.unmodifiableList(new ArrayList<Column>(this.columns));
                }
            }
            return new AdvancedCriteriaImpl(this.basePath, this.type, criterions, orders, this.maxResults, this.offset, this.spellCheckString, this.forcePagingWithDocumentOrder, this.language, this.timeZone, columns);
        }

        @Generated
        public String toString() {
            return "AdvancedCriteriaImpl.Builder(basePath=" + this.basePath + ", type=" + this.type + ", criterions=" + this.criterions + ", orders=" + this.orders + ", maxResults=" + this.maxResults + ", offset=" + this.offset + ", spellCheckString=" + this.spellCheckString + ", forcePagingWithDocumentOrder=" + this.forcePagingWithDocumentOrder + ", language=" + this.language + ", timeZone=" + this.timeZone + ", columns=" + this.columns + ")";
        }
    }
}

