/*
 * Decompiled with CFR 0.152.
 */
package nl.psek.fitnesse.documentation.plugin;

import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import nl.psek.fitnesse.documentation.CollectFitnessePages;
import nl.psek.fitnesse.documentation.FitnesseWikiDocumentationRenderer;
import nl.psek.fitnesse.documentation.WikiPage;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="report")
public class ReportMojo
extends AbstractMojo {
    @Component(role=MavenSession.class)
    protected MavenSession session;
    @Component(role=MojoExecution.class)
    protected MojoExecution execution;
    @Component(role=MavenProject.class)
    protected MavenProject project;
    @Parameter
    private List<String> suites = null;
    private List<File> files = new ArrayList<File>();
    private TreeSet<WikiPage> documentationSegments = new TreeSet<WikiPage>(new Comparator<WikiPage>(){

        @Override
        public int compare(WikiPage o1, WikiPage o2) {
            return o1.getTestcase().compareTo(o2.getTestcase());
        }
    });

    public void execute() throws MojoExecutionException {
        try {
            List testResources = this.project.getTestResources();
            for (Resource resource : testResources) {
                if (this.suites != null && !this.suites.isEmpty()) {
                    for (String suite : this.suites) {
                        String directory = resource.getDirectory() + "/" + suite;
                        this.files.addAll(CollectFitnessePages.CollectFitnessePages((String)directory));
                    }
                    continue;
                }
                this.files.addAll(CollectFitnessePages.CollectFitnessePages((String)resource.getDirectory()));
            }
            this.processFitnesseWikiPages();
            this.createIndexFile();
            this.createHtmlDocumentationDocument();
            for (File file : this.files) {
                this.getLog().info((CharSequence)("File:" + file.getCanonicalPath()));
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    private void processFitnesseWikiPages() throws IOException {
        for (File file : this.files) {
            WikiPage render = FitnesseWikiDocumentationRenderer.render((File)file);
            if (render == null) continue;
            this.documentationSegments.add(render);
        }
    }

    private void createHtmlDocumentationDocument() {
        try {
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
            configuration.setClassLoaderForTemplateLoading(ReportMojo.class.getClassLoader(), "freemarker/templates");
            configuration.setDefaultEncoding("UTF-8");
            Template index = configuration.getTemplate("index.ftl");
            HashMap<String, TreeSet<WikiPage>> dataModel = new HashMap<String, TreeSet<WikiPage>>();
            dataModel.put("wikipages", this.documentationSegments);
            index.process(dataModel, (Writer)new FileWriter(this.createIndexFile()));
        }
        catch (TemplateNotFoundException e) {
            this.getLog().error((Throwable)e);
        }
        catch (TemplateException e) {
            this.getLog().error((Throwable)e);
        }
        catch (MalformedTemplateNameException e) {
            this.getLog().error((Throwable)e);
        }
        catch (ParseException e) {
            this.getLog().error((Throwable)e);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    private File createIndexFile() {
        String buildDirectory = this.project.getBuild().getDirectory();
        String targetDirectory = buildDirectory + (buildDirectory.endsWith("/") ? "" : "/") + "fitnesse-documentation/";
        File target = new File(targetDirectory);
        if (!target.exists()) {
            if (target.mkdirs()) {
                return new File(targetDirectory + "index.html");
            }
            this.getLog().error((CharSequence)("Error creating target folder to write fitnesse documentation '" + targetDirectory + "'."));
        }
        return new File(targetDirectory + "index.html");
    }
}

