package nl.bimbase.bimworks.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class Qid implements Comparable<Qid> {
	private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
	private final UUID vid;
	private final int oid;

	private Qid(UUID vid, int oid) {
		this.vid = vid;
		this.oid = oid;
	}

	public UUID getVersionId() {
		return vid;
	}

	public int getOid() {
		return oid;
	}

	@Override
	public String toString() {
		return vid + "-" + oid;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + oid;
		result = prime * result + ((vid == null) ? 0 : vid.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Qid other = (Qid) obj;
		if (oid != other.oid)
			return false;
		if (vid == null) {
			if (other.vid != null)
				return false;
		} else if (!vid.equals(other.vid))
			return false;
		return true;
	}

	@Override
	public int compareTo(Qid o) {
		int diff = vid.compareTo(o.vid);
		if (diff == 0) {
			return Integer.compare(oid, o.oid);
		}
		return diff;
	}

	public static Qid of(String string) {
		return new Qid(UUID.fromString(string.substring(0, string.lastIndexOf("-"))),
				Integer.parseInt(string.substring(string.lastIndexOf("-") + 1)));
	}

	public static Qid of(UUID vid, int oid) {
		return new Qid(vid, oid);
	}

	public JsonNode toJson() {
		ObjectNode qidNode = OBJECT_MAPPER.createObjectNode();
		qidNode.put("vid", vid.toString());
		qidNode.put("oid", oid);
		return qidNode;
	}

	public static Collection<Qid> of(UUID vid, Set<Integer> oids) {
		List<Qid> qids = new ArrayList<>();
		for (int oid : oids) {
			qids.add(Qid.of(vid, oid));
		}
		return qids;
	}
}
