/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import nl.bimbase.bimworks.client.ApiTokenCredential;
import nl.bimbase.bimworks.client.AuthApi;
import nl.bimbase.bimworks.client.BimQuery;
import nl.bimbase.bimworks.client.BimWorksException;
import nl.bimbase.bimworks.client.FileSystemApi;
import nl.bimbase.bimworks.client.GisApi;
import nl.bimbase.bimworks.client.IfcApi;
import nl.bimbase.bimworks.client.NodeAlreadyExistsException;
import nl.bimbase.bimworks.client.TokensApi;
import nl.bimbase.bimworks.client.UploadApi;
import nl.bimbase.bimworks.client.UploadModelResponse;
import nl.sascom.backplane.appbase.library.DefaultErrorCode;
import nl.sascom.backplanepublic.client.NodeClient;
import nl.sascom.backplanepublic.common.ClientTask;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.LightContainerInterface;
import nl.sascom.backplanepublic.common.NodeClientException;
import nl.sascom.backplanepublic.common.NodeTransport;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;
import nl.sascom.backplanepublic.common.StreamAlreadyRegisteredException;
import nl.sascom.backplanepublic.common.StreamManager;

public class BimWorksClient
implements AutoCloseable {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final NodeClient nodeClient;
    public final FileSystemApi fs;
    public final GisApi gis;
    public final AuthApi auth;
    public final IfcApi ifc;
    public final UploadApi upload;
    public final TokensApi tokens;

    public BimWorksClient(NodeClient nodeClient) {
        this.nodeClient = nodeClient;
        this.fs = new FileSystemApi(this);
        this.gis = new GisApi(this);
        this.auth = new AuthApi(this);
        this.ifc = new IfcApi(this);
        this.upload = new UploadApi(this);
        this.tokens = new TokensApi(this);
    }

    public BimWorksClient(String string) throws Exception {
        this(new NodeClient(string));
    }

    public BimWorksClient(NodeTransport nodeTransport) throws Exception {
        this(new NodeClient(nodeTransport));
    }

    public BimWorksClient(NodeTransport nodeTransport, StreamManager streamManager) throws Exception {
        this(new NodeClient(nodeTransport, null, streamManager));
    }

    public BimWorksClient(NodeTransport nodeTransport, LightContainerInterface lightContainerInterface) throws Exception {
        this(new NodeClient(nodeTransport, lightContainerInterface));
    }

    @Override
    public void close() throws InterruptedException {
        this.nodeClient.close();
    }

    public NodeClient getNodeClient() {
        return this.nodeClient;
    }

    public ObjectNode loginWithUsernamePassword(String string, String string2) throws BimWorksException {
        try {
            return this.nodeClient.loginApp(string, string2);
        }
        catch (NodeClientException nodeClientException) {
            throw new BimWorksException(nodeClientException);
        }
    }

    public void loginWithApiToken(String string) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("LoginWithApiToken");
        ObjectNode objectNode = request.createObject();
        objectNode.put("token", string);
        request.setInput((JsonNode)objectNode);
        try {
            Response response = this.nodeClient.executeSync(request, 10L, TimeUnit.SECONDS);
            if (response.getOutput() == null || !response.getOutput().has("auth")) {
                throw new BimWorksException("No auth in response to login call " + (response.getErrorNode() != null ? response.getErrorNode().toString() : "") + response);
            }
            ObjectNode objectNode2 = (ObjectNode)response.getOutput().get("auth");
            this.nodeClient.setAuth(objectNode2);
            this.nodeClient.getNodeTransport().connectAsync(objectNode2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }

    public ArrayNode query(BimQuery bimQuery, String[] stringArray, Set<UUID> set) throws BimWorksException, InterruptedException {
        return this.query(bimQuery, stringArray, set.toArray(new UUID[0]));
    }

    public ArrayNode query(BimQuery bimQuery, String[] arrayNode, UUID ... uUIDArray) throws BimWorksException, InterruptedException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("TableExport");
        request.put("type", "JSON");
        request.put("output", "RESPONSE");
        request.getObjectInput().set("query", (JsonNode)bimQuery.toJson());
        ArrayNode arrayNode2 = Response.createArray();
        for (String string : arrayNode) {
            arrayNode2.add(string);
        }
        request.getObjectInput().set("paths", (JsonNode)arrayNode2);
        ArrayNode arrayNode3 = Response.createArray();
        for (UUID uUID : uUIDArray) {
            arrayNode3.add(uUID.toString());
        }
        request.getObjectInput().set("models", (JsonNode)arrayNode3);
        request.setTimeOut(1L, TimeUnit.MINUTES);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            return clientTask.await(1L, TimeUnit.MINUTES).getArrayOutput();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }

    public ObjectNode queryDelegated(BimQuery bimQuery, String[] arrayNode, Duration duration, UUID ... uUIDArray) throws BimWorksException, InterruptedException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("GenerateQueryToken");
        request.getObjectInput().set("query", (JsonNode)bimQuery.toJson());
        request.getObjectInput().put("expires_seconds", duration.toMillis());
        request.getObjectInput().put("type", "JSON");
        request.getObjectInput().put("output", "RESPONSE");
        ArrayNode arrayNode2 = Response.createArray();
        for (String string : arrayNode) {
            arrayNode2.add(string);
        }
        request.getObjectInput().set("paths", (JsonNode)arrayNode2);
        ArrayNode arrayNode3 = Response.createArray();
        for (UUID uUID : uUIDArray) {
            arrayNode3.add(uUID.toString());
        }
        request.getObjectInput().set("models", (JsonNode)arrayNode3);
        request.setTimeOut(1L, TimeUnit.MINUTES);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            return clientTask.await(1L, TimeUnit.MINUTES).getObjectOutput();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }

    public ObjectNode generateUploadToken(UUID uUID, Duration duration, Path path) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("GenerateUploadModelToTreeToken");
        ObjectNode objectNode = request.createObject();
        objectNode.put("node_uuid", uUID.toString());
        objectNode.put("expires_seconds", duration.getSeconds());
        objectNode.put("filename", path.getFileName().toString());
        try {
            objectNode.put("filesize", Files.size(path));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        objectNode.put("contentType", "application/ifc");
        request.setInput((JsonNode)objectNode);
        try {
            Response response = this.nodeClient.executeSync(request, 10L, TimeUnit.SECONDS);
            return (ObjectNode)response.getOutput();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        return null;
    }

    public UploadModelResponse uploadModelWithToken(Path path, ObjectNode objectNode) throws IOException, StreamAlreadyRegisteredException, NodeAlreadyExistsException, InterruptedException, BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setInput(objectNode.get("input"));
        request.setTask((ObjectNode)objectNode.get("task"));
        request.setTimeOut(4L, TimeUnit.HOURS);
        String string = this.nodeClient.registerStream(com.google.common.io.Files.asByteSource((File)path.toFile()));
        request.attachStream(string);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            return new UploadModelResponse((ObjectNode)clientTask.await(4L, TimeUnit.HOURS).getOutput());
        }
        catch (ExecuteException executeException) {
            if (executeException.getErrorCode().name().equals("DefaultErrorCode") && executeException.getErrorCode().getCode() == 29) {
                throw new NodeAlreadyExistsException(executeException.getUserSafeMessage());
            }
            throw new BimWorksException(executeException);
        }
    }

    public void auth(ObjectNode objectNode) {
        this.nodeClient.setAuth(objectNode);
        this.nodeClient.connectAsync(objectNode);
    }

    public ObjectNode generateDownloadToken(UUID uUID, Duration duration) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("GenerateDownloadToken");
        ObjectNode objectNode = request.createObject();
        objectNode.put("node_uuid", uUID.toString());
        objectNode.put("expires_seconds", duration.getSeconds());
        request.setInput((JsonNode)objectNode);
        try {
            Response response = this.nodeClient.executeSync(request, 10L, TimeUnit.SECONDS);
            return (ObjectNode)response.getOutput();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        return null;
    }

    public ObjectNode generateQueryToken(Set<UUID> set, BimQuery bimQuery, String[] stringArray, Duration duration) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("GenerateQueryToken");
        ObjectNode objectNode = request.createObject();
        objectNode.put("type", "JSON");
        objectNode.put("output", "RESPONSE");
        ArrayNode arrayNode = Response.createArray();
        for (UUID object : set) {
            arrayNode.add(object.toString());
        }
        objectNode.set("models", (JsonNode)arrayNode);
        objectNode.set("query", (JsonNode)bimQuery.toJson());
        ArrayNode arrayNode2 = Response.createArray();
        for (String string : stringArray) {
            arrayNode2.add(string);
        }
        objectNode.set("paths", (JsonNode)arrayNode2);
        objectNode.put("expires_seconds", duration.getSeconds());
        request.setInput((JsonNode)objectNode);
        try {
            Response executeException = this.nodeClient.executeSync(request, 10L, TimeUnit.SECONDS);
            return (ObjectNode)executeException.getOutput();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        return null;
    }

    public void downloadModelWithToken(ObjectNode objectNode) {
    }

    public String getApplicationVersion() throws IOException, ExecuteException {
        Request request = this.nodeClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("GetApplicationVersion");
        Response response = this.nodeClient.executeSync(request, 10L, TimeUnit.SECONDS);
        return response.getOutput().asText();
    }

    public String createApiToken(UUID uUID, String string, Set<String> set, Set<String> set2, Set<ApiTokenCredential> set3) throws ExecuteException, InterruptedException {
        Object object;
        Request request = this.nodeClient.createRequest();
        request.setTaskName("CreateApiToken");
        request.getObjectInput().put("node_uuid", uUID.toString());
        request.getObjectInput().put("name", string);
        if (set != null) {
            request.put("only_cors_enabled_addresses", true);
            object = Response.createArray();
            for (String object2 : set) {
                object.add(object2);
            }
            request.set("cors_enabled_domains", (JsonNode)object);
        }
        if (set2 != null) {
            request.put("only_white_listed_ip_addresses", true);
            object = Response.createArray();
            for (String string2 : set2) {
                object.add(string2);
            }
            request.set("white_listed_ip_addresses", (JsonNode)object);
        }
        if (set3 != null) {
            object = Response.createArray();
            for (ApiTokenCredential apiTokenCredential : set3) {
                object.add(apiTokenCredential.name());
            }
            request.set("credentials", (JsonNode)object);
        }
        request.setTimeOut(1L, TimeUnit.MINUTES);
        object = this.nodeClient.createAsyncTask(request);
        object.exec();
        return object.await(1L, TimeUnit.MINUTES).getObjectOutput().get("token").asText();
    }

    public ArrayNode queryWithToken(ObjectNode objectNode) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setInput(objectNode.get("input"));
        request.setTask((ObjectNode)objectNode.get("task"));
        request.setTimeOut(4L, TimeUnit.HOURS);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            return clientTask.await(4L, TimeUnit.HOURS).getArrayOutput();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            throw new BimWorksException(interruptedException.getMessage());
        }
    }

    public ArrayNode listModelsForGis() throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("ListModelsForGis");
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(30L, TimeUnit.SECONDS);
            return response.getArrayOutput();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    public NodeClient getApi() {
        return this.nodeClient;
    }

    public String getLastScreenshotNew(UUID uUID) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("GetLastScreenshotNew");
        ArrayNode arrayNode = Response.createArray();
        arrayNode.add(uUID.toString());
        request.getObjectInput().set("models", (JsonNode)arrayNode);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(30L, TimeUnit.SECONDS);
            if (response.hasStreams()) {
                // empty if block
            }
            return null;
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    public JsonNode executeAsyncTask(Request request) throws BimWorksException {
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(30L, TimeUnit.SECONDS);
            return response.getOutput();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            throw new BimWorksException(DefaultErrorCode.INTERRUPTED);
        }
    }

    public Request createRequest() {
        return this.nodeClient.createRequest();
    }

    public ClientTask createAsyncTask(Request request) {
        return this.nodeClient.createAsyncTask(request);
    }

    public String registerStream(Path path) throws StreamAlreadyRegisteredException {
        return this.nodeClient.registerStream(path);
    }

    public String registerStream(String string, String string2, String string3, long l) throws MalformedURLException, StreamAlreadyRegisteredException {
        return this.nodeClient.registerStream(string, string2, string3, l);
    }

    public String registerStream(String string, long l, String string2, InputStream inputStream) throws StreamAlreadyRegisteredException {
        return this.nodeClient.registerStream(string, l, string2, inputStream);
    }

    static {
        OBJECT_MAPPER.findAndRegisterModules();
    }
}

