/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import nl.bimbase.bimworks.client.BimQueryValidationException;
import nl.bimbase.bimworks.client.CalculatedValueQuery;
import nl.bimbase.bimworks.client.FieldQuery;
import nl.bimbase.bimworks.client.Operator;
import nl.bimbase.bimworks.client.PropertyQuery;
import nl.bimbase.bimworks.client.Qid;
import nl.bimbase.bimworks.client.UnsupportedBimQueryVersion;

public class BimQuery {
    public static final BimQuery ALL = new BimQuery();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int VERSION = 1;
    private int version = 1;
    private Set<String> types;
    private Set<Integer> buildingStoreyLevels;
    private Set<Qid> qids;
    private Map<String, FieldQuery> fields;
    private Map<String, Map<String, PropertyQuery>> propertySets;
    private Set<CalculatedValueQuery> calculatedValues;

    public BimQuery addType(String ... stringArray) {
        if (this.types == null) {
            this.types = new TreeSet<String>();
        }
        for (String string : stringArray) {
            this.types.add(string);
        }
        return this;
    }

    public BimQuery addBuildingStoreyLevel(int n) {
        if (this.buildingStoreyLevels == null) {
            this.buildingStoreyLevels = new HashSet<Integer>();
        }
        this.buildingStoreyLevels.add(n);
        return this;
    }

    public ObjectNode toJson() {
        Object object;
        ArrayNode arrayNode;
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        objectNode.put("version", this.version);
        if (this.types != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.types) {
                arrayNode.add(string);
            }
            objectNode.set("types", (JsonNode)arrayNode);
        }
        if (this.buildingStoreyLevels != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            Iterator<Object> iterator = this.buildingStoreyLevels.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                arrayNode.add(n);
            }
            objectNode.set("buildingStoreyLevels", (JsonNode)arrayNode);
        }
        if (this.qids != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (Qid qid : this.qids) {
                arrayNode.add(qid.toString());
            }
            objectNode.set("qids", (JsonNode)arrayNode);
        }
        if (this.fields != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.fields.keySet()) {
                object = this.fields.get(string);
                arrayNode.add((JsonNode)((FieldQuery)object).toJson());
            }
            objectNode.set("fields", (JsonNode)arrayNode);
        }
        if (this.propertySets != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (String string : this.propertySets.keySet()) {
                object = this.propertySets.get(string);
                for (String string2 : object.keySet()) {
                    arrayNode.add((JsonNode)((PropertyQuery)object.get(string2)).toJson());
                }
            }
            objectNode.set("properties", (JsonNode)arrayNode);
        }
        if (this.calculatedValues != null) {
            arrayNode = OBJECT_MAPPER.createArrayNode();
            for (CalculatedValueQuery calculatedValueQuery : this.calculatedValues) {
                arrayNode.add((JsonNode)calculatedValueQuery.toJson());
            }
            objectNode.set("calculatedValues", (JsonNode)arrayNode);
        }
        return objectNode;
    }

    public BimQuery addProperty(String string, String string2, Operator operator, JsonNode jsonNode) {
        Map<String, PropertyQuery> map;
        if (this.propertySets == null) {
            this.propertySets = new HashMap<String, Map<String, PropertyQuery>>();
        }
        if ((map = this.propertySets.get(string)) == null) {
            map = new HashMap<String, PropertyQuery>();
            this.propertySets.put(string, map);
        }
        map.put(string2, new PropertyQuery(string, string2, operator, jsonNode));
        return this;
    }

    public static BimQuery of(JsonNode jsonNode) throws UnsupportedBimQueryVersion, BimQueryValidationException {
        String[] stringArray;
        ArrayNode arrayNode;
        if (jsonNode == null) {
            return ALL;
        }
        BimQuery bimQuery = new BimQuery();
        if (!jsonNode.has("version")) {
            throw new BimQueryValidationException("version field is required");
        }
        bimQuery.version = jsonNode.get("version").asInt();
        if (bimQuery.version != 1) {
            throw new UnsupportedBimQueryVersion(bimQuery.version, 1);
        }
        if (jsonNode.has("types")) {
            arrayNode = (ArrayNode)jsonNode.get("types");
            for (JsonNode jsonNode2 : arrayNode) {
                bimQuery.addType(jsonNode2.asText());
            }
        }
        if (jsonNode.has("buildingStoreyLevels")) {
            arrayNode = (ArrayNode)jsonNode.get("buildingStoreyLevels");
            for (JsonNode jsonNode2 : arrayNode) {
                bimQuery.addBuildingStoreyLevel(jsonNode2.asInt());
            }
        }
        if (jsonNode.has("qids")) {
            arrayNode = (ArrayNode)jsonNode.get("qids");
            for (JsonNode jsonNode2 : arrayNode) {
                bimQuery.addQid(Qid.of(jsonNode2.asText()));
            }
        }
        if (jsonNode.has("fields")) {
            arrayNode = (ArrayNode)jsonNode.get("fields");
            for (JsonNode jsonNode2 : arrayNode) {
                bimQuery.addField(jsonNode2.get("name").asText(), Operator.bySymbol(jsonNode2.get("operator").asText()), jsonNode2.get("value"));
            }
        }
        if (jsonNode.has("properties")) {
            arrayNode = (ArrayNode)jsonNode.get("properties");
            for (JsonNode jsonNode2 : arrayNode) {
                String[] stringArray2 = stringArray = jsonNode2.has("propertySetName") ? jsonNode2.get("propertySetName").asText() : null;
                if (jsonNode2.has("value")) {
                    bimQuery.addProperty((String)stringArray, jsonNode2.get("name").asText(), Operator.bySymbol(jsonNode2.get("operator").asText()), jsonNode2.get("value"));
                    continue;
                }
                bimQuery.addProperty((String)stringArray, jsonNode2.get("name").asText());
            }
        }
        if (jsonNode.has("calculatedValues")) {
            arrayNode = (ArrayNode)jsonNode.get("calculatedValues");
            for (JsonNode jsonNode2 : arrayNode) {
                if (!jsonNode2.has("name")) continue;
                stringArray = jsonNode2.get("name").asText().split("\\.");
                bimQuery.addCalculatedValue(new CalculatedValueQuery(stringArray, Operator.bySymbol(jsonNode2.get("operator").asText()), jsonNode2.get("value")));
            }
        }
        return bimQuery;
    }

    public String toString() {
        return this.toJson().toString();
    }

    private void addQid(Qid qid) {
        if (this.qids == null) {
            this.qids = new TreeSet<Qid>();
        }
        this.qids.add(qid);
    }

    public void addField(String string, Operator operator, JsonNode jsonNode) {
        if (this.fields == null) {
            this.fields = new TreeMap<String, FieldQuery>();
        }
        this.fields.put(string, new FieldQuery(string, operator, jsonNode));
    }

    public void addField(String string, Operator operator, double d) {
        if (this.fields == null) {
            this.fields = new TreeMap<String, FieldQuery>();
        }
        this.fields.put(string, new FieldQuery(string, operator, (JsonNode)DoubleNode.valueOf((double)d)));
    }

    public BimQuery addProperty(String string, String string2) {
        Map<String, PropertyQuery> map;
        if (this.propertySets == null) {
            this.propertySets = new TreeMap<String, Map<String, PropertyQuery>>();
        }
        if ((map = this.propertySets.get(string)) == null) {
            map = new TreeMap<String, PropertyQuery>();
            this.propertySets.put(string, map);
        }
        map.put(string2, new PropertyQuery(string, string2, Operator.EXISTS, null));
        return this;
    }

    public BimQuery addCalculatedValue(CalculatedValueQuery calculatedValueQuery) {
        if (this.calculatedValues == null) {
            this.calculatedValues = new TreeSet<CalculatedValueQuery>();
        }
        this.calculatedValues.add(calculatedValueQuery);
        return this;
    }
}

