package nl.bimbase.bimworks.api.bim;

import java.util.HashMap;
import java.util.Map;

import nl.sascom.backplanepublic.common.ErrorCode;

public enum AuthorizationError implements ErrorCode {

	NO_WRITE_RIGHTS(0), NO_READ_RIGHTS(1), NO_AUTHORIZATION(2), NON_AUTHORIZED_TASK(3), NON_AUTHORIZED_IP_ADDRESS(4);
	
	private int code;
	private static final Map<Integer, AuthorizationError> MAP = new HashMap<>();

	AuthorizationError(int code) {
		this.code = code;
	}
	
	public int getCode() {
		return code;
	}

	public String getMessage() {
		return name();
	}
	
	public static AuthorizationError fromCode(int code) {
		return MAP.get(code);
	}
	
	static {
		for (AuthorizationError bimWorksErrorCode : values()) {
			MAP.put(bimWorksErrorCode.getCode(), bimWorksErrorCode);
		}
	}
}