package nl.bimbase.bimworks.client;

import nl.sascom.backplanepublic.common.ErrorCode;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.NodeClientException;

public class BimWorksException extends Exception {

	private ErrorCode errorCode;

	public BimWorksException(String message) {
		super(message);
	}

	public BimWorksException(NodeClientException e) {
		super(e);
		this.errorCode = e.getErrorCode();
	}

	public BimWorksException(ExecuteException e) {
		super(e);
		this.errorCode = e.getErrorCode();
	}
	
	public ErrorCode getErrorCode() {
		return errorCode;
	}
}
