package nl.bimbase.bimworks.api.bim;

import java.util.HashMap;
import java.util.Map;

import nl.sascom.backplanepublic.common.ErrorCode;

public enum AuthenticationError implements ErrorCode {

	INVALID_API_TOKEN(0), API_TOKEN_DELETED(1), INVALID_LOGIN(2), EMAIL_ADDRESS_NOT_VALIDATED(3), INVALID_INVITE_CODE(4), ACCOUNT_DELETED(5), TOKEN_EXPIRED(6), INVALID_HMAC(7), ONLY_API_TOKEN_ALLOWED(8), NO_INPUT_IN_AUTH(9), NO_TYPE_IN_INPUT(10), NO_AUTH(11);
	
	private int code;
	private static final Map<Integer, AuthenticationError> MAP = new HashMap<>();

	AuthenticationError(int code) {
		this.code = code;
	}
	
	public int getCode() {
		return code;
	}

	public String getMessage() {
		return name();
	}
	
	public static AuthenticationError fromCode(int code) {
		return MAP.get(code);
	}
	
	static {
		for (AuthenticationError bimWorksErrorCode : values()) {
			MAP.put(bimWorksErrorCode.getCode(), bimWorksErrorCode);
		}
	}
}