/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import nl.bimbase.bimworks.client.ApiTokenCredential;
import nl.bimbase.bimworks.client.BimQuery;
import nl.bimbase.bimworks.client.BimWorksException;
import nl.bimbase.bimworks.client.NodeAlreadyExistsException;
import nl.bimbase.bimworks.client.TreeNode;
import nl.bimbase.bimworks.client.TreeNodeVersion;
import nl.bimbase.bimworks.client.UploadModelResponse;
import nl.bimbase.bimworks.client.UploadOption;
import nl.sascom.backplanepublic.client.NodeClient;
import nl.sascom.backplanepublic.common.ClientTask;
import nl.sascom.backplanepublic.common.CommonErrorCode;
import nl.sascom.backplanepublic.common.ErrorCode;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.LightContainerInterface;
import nl.sascom.backplanepublic.common.NodeClientException;
import nl.sascom.backplanepublic.common.NodeTransport;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;
import nl.sascom.backplanepublic.common.StreamAlreadyRegisteredException;
import nl.sascom.backplanepublic.common.StreamManager;
import nl.sascom.backplanepublic.common.utils.HashingUtils;

public class BimWorksClient
implements AutoCloseable {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private NodeClient nodeClient;

    public BimWorksClient(String string) throws Exception {
        this.nodeClient = new NodeClient(string);
    }

    public BimWorksClient(NodeTransport nodeTransport) throws Exception {
        this.nodeClient = new NodeClient(nodeTransport);
    }

    public BimWorksClient(NodeTransport nodeTransport, StreamManager streamManager) throws Exception {
        this.nodeClient = new NodeClient(nodeTransport, null, streamManager);
    }

    public BimWorksClient(NodeTransport nodeTransport, LightContainerInterface lightContainerInterface) throws Exception {
        this.nodeClient = new NodeClient(nodeTransport, lightContainerInterface);
    }

    @Override
    public void close() throws InterruptedException {
        this.nodeClient.close();
    }

    public NodeClient getNodeClient() {
        return this.nodeClient;
    }

    public ObjectNode loginWithUsernamePassword(String string, String string2) throws BimWorksException {
        try {
            return this.nodeClient.loginApp(string, string2);
        }
        catch (NodeClientException nodeClientException) {
            throw new BimWorksException(nodeClientException);
        }
    }

    public void loginWithApiToken(String string) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("LoginWithApiToken");
        ObjectNode objectNode = request.createObject();
        objectNode.put("token", string);
        request.setInput((JsonNode)objectNode);
        try {
            Response response = this.nodeClient.executeSync(request, 10L, TimeUnit.SECONDS);
            if (response.getOutput() == null || !response.getOutput().has("auth")) {
                throw new BimWorksException("No auth in response to login call " + (response.getErrorNode() != null ? response.getErrorNode().toString() : "") + response);
            }
            ObjectNode objectNode2 = (ObjectNode)response.getOutput().get("auth");
            this.nodeClient.setAuth(objectNode2);
            this.nodeClient.getNodeTransport().connectAsync(objectNode2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }

    public UUID getRootNodeUuid() throws InterruptedException, BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("GetNodeByPath");
        request.put("path", "/");
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(30L, TimeUnit.SECONDS);
            return UUID.fromString(response.getOutput().get("uuid").asText());
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }

    public UUID createNode(UUID uUID, String string, boolean bl) throws BimWorksException, InterruptedException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("CreateNode");
        request.put("parent_node_uuid", uUID.toString());
        request.put("name", string);
        request.put("folder", bl);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(30L, TimeUnit.SECONDS);
            return UUID.fromString(response.getOutput().asText());
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }

    public UploadModelResponse uploadModel(UUID uUID, Path path) throws IOException, InterruptedException, BimWorksException, StreamAlreadyRegisteredException, NodeAlreadyExistsException {
        return this.uploadModel(uUID, path, null);
    }

    public UploadModelResponse uploadModel(UUID uUID, Path path, UploadOption uploadOption) throws IOException, InterruptedException, BimWorksException, StreamAlreadyRegisteredException, NodeAlreadyExistsException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("UploadModelToTree");
        request.put("filename", path.getFileName().toString());
        request.put("filesize", Long.valueOf(Files.size(path)));
        request.put("contentType", "application/ifc");
        request.put("node_uuid", uUID.toString());
        ObjectNode objectNode = Response.createObject();
        if (uploadOption != null) {
            objectNode.put("force", uploadOption.name());
        }
        request.set("options", (JsonNode)objectNode);
        ObjectNode objectNode2 = Response.createObject();
        request.set("hash", (JsonNode)objectNode2);
        try (Object object = Files.newInputStream(path, new OpenOption[0]);){
            objectNode2.put("partial_sha256", HashingUtils.extractPartialSha256((InputStream)object));
        }
        request.setTimeOut(4L, TimeUnit.HOURS);
        object = this.nodeClient.registerStream(path);
        request.attachStream((String)object);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(4L, TimeUnit.HOURS);
            return new UploadModelResponse(response.getObjectOutput());
        }
        catch (ExecuteException executeException) {
            if (executeException.getErrorCode().name().equals("DefaultErrorCode") && executeException.getErrorCode().getCode() == 29) {
                throw new NodeAlreadyExistsException(executeException.getUserSafeMessage());
            }
            throw new BimWorksException(executeException);
        }
    }

    public UploadModelResponse uploadModel(UUID uUID, String string, String string2, String string3, long l) throws IOException, InterruptedException, BimWorksException, StreamAlreadyRegisteredException, NodeAlreadyExistsException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("UploadModelToTree");
        request.put("filename", string);
        request.put("filesize", Long.valueOf(l));
        request.put("contentType", "application/ifc");
        request.put("node_uuid", uUID.toString());
        request.setTimeOut(4L, TimeUnit.HOURS);
        String string4 = this.nodeClient.registerStream(string, string2, string3, l);
        request.attachStream(string4);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(4L, TimeUnit.HOURS);
            if (response.getObjectOutput() == null) {
                throw new ExecuteException((ErrorCode)CommonErrorCode.NO_OUTPUT_IN_RESPONSE);
            }
            return new UploadModelResponse(response.getObjectOutput());
        }
        catch (ExecuteException executeException) {
            if (executeException.getErrorCode().name().equals("DefaultErrorCode") && executeException.getErrorCode().getCode() == 29) {
                throw new NodeAlreadyExistsException(executeException.getUserSafeMessage());
            }
            throw new BimWorksException(executeException);
        }
    }

    public boolean exists(String string) throws InterruptedException, BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("NodeExists");
        request.put("path", string);
        request.setTimeOut(1L, TimeUnit.MINUTES);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(1L, TimeUnit.MINUTES);
            return response.getOutput().asBoolean();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }

    public int clearRepository() throws InterruptedException, BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("ClearNodeChildren");
        request.put("node_uuid", this.getRootNodeUuid().toString());
        request.setTimeOut(10L, TimeUnit.MINUTES);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(1L, TimeUnit.MINUTES);
            return response.getOutput().asInt();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }

    public ArrayNode query(BimQuery bimQuery, String[] stringArray, Set<UUID> set) throws BimWorksException, InterruptedException {
        return this.query(bimQuery, stringArray, set.toArray(new UUID[0]));
    }

    public ArrayNode query(BimQuery bimQuery, String[] arrayNode, UUID ... clientTask) throws BimWorksException, InterruptedException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("TableExport");
        request.put("type", "JSON");
        request.put("output", "RESPONSE");
        request.getObjectInput().set("query", (JsonNode)bimQuery.toJson());
        ArrayNode arrayNode2 = Response.createArray();
        for (String string : arrayNode) {
            arrayNode2.add(string);
        }
        request.getObjectInput().set("paths", (JsonNode)arrayNode2);
        ArrayNode arrayNode3 = Response.createArray();
        for (UUID uUID : clientTask) {
            arrayNode3.add(uUID.toString());
        }
        request.getObjectInput().set("models", (JsonNode)arrayNode3);
        request.setTimeOut(1L, TimeUnit.MINUTES);
        ClientTask clientTask2 = this.nodeClient.createAsyncTask(request);
        try {
            clientTask2.exec();
            return clientTask2.await(1L, TimeUnit.MINUTES).getArrayOutput();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }

    public ObjectNode queryDelegated(BimQuery bimQuery, String[] arrayNode, Duration duration, UUID ... clientTask) throws BimWorksException, InterruptedException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("GenerateQueryToken");
        request.getObjectInput().set("query", (JsonNode)bimQuery.toJson());
        request.getObjectInput().put("expires_seconds", duration.toMillis());
        request.getObjectInput().put("type", "JSON");
        request.getObjectInput().put("output", "RESPONSE");
        ArrayNode arrayNode2 = Response.createArray();
        for (String string : arrayNode) {
            arrayNode2.add(string);
        }
        request.getObjectInput().set("paths", (JsonNode)arrayNode2);
        ArrayNode arrayNode3 = Response.createArray();
        for (UUID uUID : clientTask) {
            arrayNode3.add(uUID.toString());
        }
        request.getObjectInput().set("models", (JsonNode)arrayNode3);
        request.setTimeOut(1L, TimeUnit.MINUTES);
        ClientTask clientTask2 = this.nodeClient.createAsyncTask(request);
        try {
            clientTask2.exec();
            return clientTask2.await(1L, TimeUnit.MINUTES).getObjectOutput();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
    }

    public TreeNode getNode(String string) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("GetNodeByPath");
        request.getObjectInput().put("path", string);
        request.setTimeOut(1L, TimeUnit.MINUTES);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            return (TreeNode)OBJECT_MAPPER.convertValue((Object)clientTask.await(1L, TimeUnit.MINUTES).getObjectOutput(), TreeNode.class);
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public ObjectNode generateUploadToken(UUID uUID, Duration duration, Path path) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("GenerateUploadModelToTreeToken");
        ObjectNode objectNode = request.createObject();
        objectNode.put("node_uuid", uUID.toString());
        objectNode.put("expires_seconds", duration.getSeconds());
        objectNode.put("filename", path.getFileName().toString());
        try {
            objectNode.put("filesize", Files.size(path));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        objectNode.put("contentType", "application/ifc");
        request.setInput((JsonNode)objectNode);
        try {
            Response response = this.nodeClient.executeSync(request, 10L, TimeUnit.SECONDS);
            return (ObjectNode)response.getOutput();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        return null;
    }

    public UploadModelResponse uploadModelWithToken(Path path, ObjectNode objectNode) throws IOException, StreamAlreadyRegisteredException, NodeAlreadyExistsException, InterruptedException, BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setInput(objectNode.get("input"));
        request.setTask((ObjectNode)objectNode.get("task"));
        request.setTimeOut(4L, TimeUnit.HOURS);
        String string = this.nodeClient.registerStream(com.google.common.io.Files.asByteSource((File)path.toFile()));
        request.attachStream(string);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            return new UploadModelResponse((ObjectNode)clientTask.await(4L, TimeUnit.HOURS).getOutput());
        }
        catch (ExecuteException executeException) {
            if (executeException.getErrorCode().name().equals("DefaultErrorCode") && executeException.getErrorCode().getCode() == 29) {
                throw new NodeAlreadyExistsException(executeException.getUserSafeMessage());
            }
            throw new BimWorksException(executeException);
        }
    }

    public void auth(ObjectNode objectNode) {
        this.nodeClient.setAuth(objectNode);
        this.nodeClient.connectAsync(objectNode);
    }

    public ObjectNode generateDownloadToken(UUID uUID, Duration duration) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("GenerateDownloadToken");
        ObjectNode objectNode = request.createObject();
        objectNode.put("node_uuid", uUID.toString());
        objectNode.put("expires_seconds", duration.getSeconds());
        request.setInput((JsonNode)objectNode);
        try {
            Response response = this.nodeClient.executeSync(request, 10L, TimeUnit.SECONDS);
            return (ObjectNode)response.getOutput();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        return null;
    }

    public ObjectNode generateQueryToken(Set<UUID> set, BimQuery bimQuery, String[] response, Duration duration) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("GenerateQueryToken");
        ObjectNode objectNode = request.createObject();
        objectNode.put("type", "JSON");
        objectNode.put("output", "RESPONSE");
        ArrayNode arrayNode = Response.createArray();
        for (UUID response2 : set) {
            arrayNode.add(response2.toString());
        }
        objectNode.set("models", (JsonNode)arrayNode);
        objectNode.set("query", (JsonNode)bimQuery.toJson());
        ArrayNode arrayNode2 = Response.createArray();
        for (Response response2 : response) {
            arrayNode2.add((String)response2);
        }
        objectNode.set("paths", (JsonNode)arrayNode2);
        objectNode.put("expires_seconds", duration.getSeconds());
        request.setInput((JsonNode)objectNode);
        try {
            Response executeException = this.nodeClient.executeSync(request, 10L, TimeUnit.SECONDS);
            return (ObjectNode)executeException.getOutput();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        return null;
    }

    public void downloadModelWithToken(ObjectNode objectNode) {
    }

    public String getApplicationVersion() throws IOException, ExecuteException {
        Request request = this.nodeClient.createRequest();
        request.setProject("BimRepository");
        request.setTaskName("GetApplicationVersion");
        Response response = this.nodeClient.executeSync(request, 10L, TimeUnit.SECONDS);
        return response.getOutput().asText();
    }

    public String createApiToken(UUID uUID, String string, Set<String> set, Set<String> set2, Set<ApiTokenCredential> set3) throws ExecuteException, InterruptedException {
        ArrayNode arrayNode;
        Request request = this.nodeClient.createRequest();
        request.setTaskName("CreateApiToken");
        request.getObjectInput().put("node_uuid", uUID.toString());
        request.getObjectInput().put("name", string);
        if (set != null) {
            request.put("only_cors_enabled_addresses", true);
            arrayNode = Response.createArray();
            for (String object : set) {
                arrayNode.add(object);
            }
            request.set("cors_enabled_domains", (JsonNode)arrayNode);
        }
        if (set2 != null) {
            request.put("only_white_listed_ip_addresses", true);
            arrayNode = Response.createArray();
            for (String string2 : set2) {
                arrayNode.add(string2);
            }
            request.set("white_listed_ip_addresses", (JsonNode)arrayNode);
        }
        if (set3 != null) {
            arrayNode = Response.createArray();
            for (ApiTokenCredential apiTokenCredential : set3) {
                arrayNode.add(apiTokenCredential.name());
            }
            request.set("credentials", (JsonNode)arrayNode);
        }
        request.setTimeOut(1L, TimeUnit.MINUTES);
        arrayNode = this.nodeClient.createAsyncTask(request);
        arrayNode.exec();
        return arrayNode.await(1L, TimeUnit.MINUTES).getObjectOutput().get("token").asText();
    }

    public ObjectNode listNodes(UUID uUID) throws InterruptedException, ExecuteException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("ListNodes");
        request.getObjectInput().put("parent_node_uuid", uUID.toString());
        request.setTimeOut(1L, TimeUnit.MINUTES);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        clientTask.exec();
        return clientTask.await(1L, TimeUnit.MINUTES).getObjectOutput();
    }

    public ArrayNode queryWithToken(ObjectNode objectNode) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setInput(objectNode.get("input"));
        request.setTask((ObjectNode)objectNode.get("task"));
        request.setTimeOut(4L, TimeUnit.HOURS);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            return clientTask.await(4L, TimeUnit.HOURS).getArrayOutput();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            throw new BimWorksException(interruptedException.getMessage());
        }
    }

    public void deleteNodeIfExists(String string) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("DeleteNodeIfExists");
        request.put("path", string);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(30L, TimeUnit.SECONDS);
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public TreeNode getRootNode() throws BimWorksException {
        return this.getNode("/");
    }

    public UUID createNodeIfNotExists(UUID uUID, String string, boolean bl) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("CreateNodeIfNotExists");
        request.put("name", string);
        request.put("parent_node_uuid", uUID.toString());
        request.put("folder", bl);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(30L, TimeUnit.SECONDS);
            return UUID.fromString(response.getOutput().asText());
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    public ArrayNode listModelsForGis() throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("ListModelsForGis");
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(30L, TimeUnit.SECONDS);
            return response.getArrayOutput();
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    public NodeClient getApi() {
        return this.nodeClient;
    }

    public String getLastScreenshotNew(UUID uUID) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("GetLastScreenshotNew");
        ArrayNode arrayNode = Response.createArray();
        arrayNode.add(uUID.toString());
        request.getObjectInput().set("models", (JsonNode)arrayNode);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(30L, TimeUnit.SECONDS);
            if (response.hasStreams()) {
                // empty if block
            }
            return null;
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    public TreeNode getNodeByUuid(UUID uUID) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("GetNodeByUuid");
        request.getObjectInput().put("node_uuid", uUID.toString());
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(30L, TimeUnit.SECONDS);
            return (TreeNode)Response.OBJECT_MAPPER.convertValue((Object)response.getObjectOutput(), TreeNode.class);
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    public TreeNodeVersion getNodeVersionByUuid(UUID uUID) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("GetVersionByUuid");
        request.getObjectInput().put("version_uuid", uUID.toString());
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(30L, TimeUnit.SECONDS);
            return (TreeNodeVersion)Response.OBJECT_MAPPER.convertValue((Object)response.getObjectOutput(), TreeNodeVersion.class);
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    public TreeNode getNodeByVersionUuid(UUID uUID) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("GetNodeByVersionUuid");
        request.getObjectInput().put("version_uuid", uUID.toString());
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            clientTask.exec();
            Response response = clientTask.await(30L, TimeUnit.SECONDS);
            return (TreeNode)Response.OBJECT_MAPPER.convertValue((Object)response.getObjectOutput(), TreeNode.class);
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    public ObjectNode createVersionsToken(Set<UUID> set, Duration duration) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("CreateVersionsToken");
        ArrayNode arrayNode = Response.createArray();
        for (UUID uUID : set) {
            arrayNode.add(uUID.toString());
        }
        request.getObjectInput().put("expires_seconds", duration.getSeconds());
        request.getObjectInput().set("version_uuids", (JsonNode)arrayNode);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            UUID uUID;
            clientTask.exec();
            uUID = clientTask.await(30L, TimeUnit.SECONDS);
            return (ObjectNode)uUID.getObjectOutput().get("auth");
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    public ObjectNode createNodesToken(Set<UUID> set, Duration duration) throws BimWorksException {
        Request request = this.nodeClient.createRequest();
        request.setTaskName("CreateNodesToken");
        ArrayNode arrayNode = Response.createArray();
        for (UUID uUID : set) {
            arrayNode.add(uUID.toString());
        }
        request.getObjectInput().put("expires_seconds", duration.getSeconds());
        request.getObjectInput().set("node_uuids", (JsonNode)arrayNode);
        ClientTask clientTask = this.nodeClient.createAsyncTask(request);
        try {
            UUID uUID;
            clientTask.exec();
            uUID = clientTask.await(30L, TimeUnit.SECONDS);
            return (ObjectNode)uUID.getObjectOutput().get("auth");
        }
        catch (ExecuteException executeException) {
            throw new BimWorksException(executeException);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    static {
        OBJECT_MAPPER.findAndRegisterModules();
    }
}

