/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import nl.sascom.backplanepublic.common.JsonUpdate;
import nl.sascom.backplanepublic.common.ResponseType;
import nl.sascom.backplanepublic.common.TaskStatus;

public class StatusChange
extends JsonUpdate {
    private TaskStatus taskStatus;
    private TaskStatus oldStatus;
    private boolean debug;

    public StatusChange(UUID uUID, TaskStatus taskStatus, TaskStatus taskStatus2) {
        super(uUID);
        this.oldStatus = taskStatus;
        this.taskStatus = taskStatus2;
    }

    public StatusChange(byte[] byArray) {
        super(byArray);
    }

    @Override
    public void setData(ObjectNode objectNode) {
        this.taskStatus = TaskStatus.valueOf(objectNode.get("status").asText());
        this.oldStatus = TaskStatus.valueOf(objectNode.get("oldStatus").asText());
    }

    @Override
    public ResponseType getResponseType() {
        return ResponseType.STATUS_CHANGE;
    }

    @Override
    public ObjectNode toJson() {
        ObjectNode objectNode = super.toJson();
        objectNode.put("status", this.taskStatus.name());
        objectNode.put("oldStatus", this.oldStatus.name());
        if (this.debug) {
            objectNode.put("debug", true);
        }
        return objectNode;
    }

    public TaskStatus getOldStatus() {
        return this.oldStatus;
    }

    public TaskStatus getStatus() {
        return this.taskStatus;
    }

    public String toString() {
        return "Status change: " + this.oldStatus + " -> " + this.taskStatus;
    }

    @Override
    public String getSubType() {
        return this.taskStatus.name();
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

