/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import nl.sascom.backplanepublic.common.JsonUpdate;
import nl.sascom.backplanepublic.common.ResponseType;

public class Progress
extends JsonUpdate {
    private int progress;
    private String label;
    private boolean debug;

    public Progress(byte[] byArray) {
        super(byArray);
    }

    @Override
    public void setData(ObjectNode objectNode) {
        this.label = objectNode.get("label").asText();
        this.progress = objectNode.get("progress").asInt();
    }

    public Progress(UUID uUID, String string, int n) {
        super(uUID);
        this.label = string;
        this.progress = n;
    }

    @Override
    public ObjectNode toJson() {
        ObjectNode objectNode = super.toJson();
        objectNode.put("progress", this.progress);
        objectNode.put("label", this.label);
        if (this.debug) {
            objectNode.put("debug", true);
        }
        return objectNode;
    }

    @Override
    public ResponseType getResponseType() {
        return ResponseType.PROGRESS;
    }

    public String toString() {
        return "Progress: " + this.label + " " + this.progress + "%";
    }

    public int getProgress() {
        return this.progress;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public String getSubType() {
        return null;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public static Progress of(ObjectNode objectNode) {
        if (objectNode == null) {
            return null;
        }
        Progress progress = new Progress(null, objectNode.get("label").asText(), objectNode.get("progress").asInt());
        return progress;
    }
}

