/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplane.appbase.library.ssh;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import nl.sascom.backplane.appbase.library.ssh.SshException;
import nl.sascom.backplane.appbase.library.ssh.SshSettings;
import nl.sascom.backplanepublic.common.logging.Log;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class SshChannel
implements AutoCloseable {
    private Log log;
    private Session session;

    public SshChannel(Session session, Log log) {
        this.session = session;
        this.log = log;
    }

    @Override
    public void close() throws SshException {
    }

    public String exec(String string) throws SshException {
        return this.exec(string, SshSettings.DEFAULT);
    }

    public String exec(String string, final SshSettings sshSettings) throws SshException {
        final StringBuilder stringBuilder = new StringBuilder();
        final StringBuilder stringBuilder2 = new StringBuilder();
        final StringBuilder stringBuilder3 = new StringBuilder();
        if (sshSettings.logInfo) {
            this.log.info("Executing " + string);
        }
        for (int i = 0; i <= sshSettings.maxRetries; ++i) {
            ChannelExec channelExec = null;
            try {
                final CountDownLatch countDownLatch = new CountDownLatch(2);
                channelExec = (ChannelExec)this.session.openChannel("exec");
                channelExec.setPty(true);
                channelExec.setCommand(string);
                final StringBuilder stringBuilder4 = new StringBuilder();
                OutputStream outputStream = new OutputStream(){

                    @Override
                    public void write(int n) throws IOException {
                    }

                    @Override
                    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
                        String string = new String(byArray, n, n2, Charsets.UTF_8);
                        stringBuilder2.append(string);
                        stringBuilder.append(string);
                        String string2 = stringBuilder.toString();
                        while (string2.contains("\n")) {
                            String string3 = string2.substring(0, string2.indexOf("\n"));
                            if (sshSettings.logOutput) {
                                SshChannel.this.log.info(string3);
                            }
                            string2 = string2.substring(string2.indexOf("\n") + 1);
                        }
                        stringBuilder.delete(0, stringBuilder.length());
                        stringBuilder.append(string2);
                    }

                    @Override
                    public void close() throws IOException {
                        countDownLatch.countDown();
                    }
                };
                OutputStream outputStream2 = new OutputStream(){

                    @Override
                    public void write(int n) throws IOException {
                    }

                    @Override
                    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
                        String string = new String(byArray, n, n2, Charsets.UTF_8);
                        stringBuilder4.append(string);
                        stringBuilder3.append(string);
                        String string2 = stringBuilder4.toString();
                        while (string2.contains("\n")) {
                            String string3 = string2.substring(0, string2.indexOf("\n"));
                            if (sshSettings.logError) {
                                SshChannel.this.log.error(string3);
                            }
                            string2 = string2.substring(string2.indexOf("\n") + 1);
                        }
                        stringBuilder4.delete(0, stringBuilder4.length());
                        stringBuilder4.append(string2);
                    }

                    @Override
                    public void close() throws IOException {
                        countDownLatch.countDown();
                    }
                };
                channelExec.setOutputStream(outputStream);
                channelExec.setErrStream(outputStream2);
                try {
                    channelExec.connect();
                }
                catch (JSchException jSchException) {
                    if (sshSettings.logError) {
                        this.log.error(jSchException);
                    }
                    try {
                        Thread.sleep(i * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    if (channelExec == null) continue;
                    channelExec.disconnect();
                    continue;
                }
                if (sshSettings.wait) {
                    try {
                        countDownLatch.await(sshSettings.getTimeOut(), sshSettings.getTimeOutUnit());
                        try {
                            outputStream.flush();
                            outputStream2.flush();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        int n = 0;
                        while (!channelExec.isClosed()) {
                            if (sshSettings.logInfo) {
                                this.log.info("Waiting for channel to close");
                            }
                            Thread.sleep(1000L);
                            if (++n <= 10) continue;
                            this.log.error("Channel doesn't seem to close");
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.log.error(interruptedException);
                    }
                    if (channelExec.getExitStatus() != 0 && !sshSettings.allowNonZeroExitState) {
                        if (i >= sshSettings.maxRetries) {
                            throw new SshException("No exit status 0, but " + channelExec.getExitStatus() + " from calling " + string, stringBuilder2.toString(), stringBuilder3.toString());
                        }
                        if (sshSettings.logInfo) {
                            this.log.info("Retrying " + string);
                        }
                        try {
                            Thread.sleep(i * 1000);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    String string2 = stringBuilder2.toString();
                    return string2;
                }
                String string3 = stringBuilder2.toString();
                return string3;
            }
            catch (JSchException jSchException) {
                throw new SshException(jSchException.getMessage(), (Exception)((Object)jSchException));
            }
            finally {
                if (channelExec != null) {
                    channelExec.disconnect();
                }
            }
        }
        return stringBuilder2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromRemoteServer(String string, OutputStream outputStream) throws IOException, JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.session.openChannel("sftp");
        channelSftp.connect();
        try {
            channelSftp.get(string, outputStream);
        }
        finally {
            channelSftp.disconnect();
        }
    }

    public String getTextFile(String string) throws IOException, JSchException, SftpException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.copyFromRemoteServer(string, (OutputStream)byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray(), Charsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToRemoteServer(String string, long l, InputStream inputStream) throws IOException, JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.session.openChannel("sftp");
        channelSftp.connect();
        try {
            if (string.contains("/")) {
                channelSftp.cd(string.substring(0, string.lastIndexOf("/")));
                string = string.substring(string.lastIndexOf("/") + 1);
            }
            channelSftp.put(inputStream, string);
        }
        finally {
            channelSftp.disconnect();
        }
    }

    public void copyToRemoteServer(String string, String string2) throws IOException, JSchException, SftpException {
        this.copyToRemoteServer(string, string2.getBytes(Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToRemoteServer(String string, byte[] byArray) throws IOException, JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.session.openChannel("sftp");
        channelSftp.connect();
        try {
            if (string.contains("/")) {
                channelSftp.cd(string.substring(0, string.lastIndexOf("/")));
                string = string.substring(string.lastIndexOf("/") + 1);
            }
            channelSftp.put((InputStream)new ByteArrayInputStream(byArray), string);
        }
        finally {
            channelSftp.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String string) throws JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.session.openChannel("sftp");
        channelSftp.connect();
        try {
            SftpATTRS sftpATTRS = null;
            try {
                sftpATTRS = channelSftp.stat(string);
            }
            catch (Exception exception) {
                boolean bl = false;
                channelSftp.disconnect();
                return bl;
            }
            if (sftpATTRS != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            channelSftp.disconnect();
        }
    }

    public void mkdir(String string) throws SshException {
        this.exec("mkdir " + string, SshSettings.DEFAULT.allowNonZeroExitState(true));
    }

    public void delete(String string) throws SshException {
        this.exec("rm " + string, SshSettings.DEFAULT.allowNonZeroExitState(true));
    }

    public void install(String ... stringArray) throws SshException {
        this.exec("apt-get install -y " + Joiner.on((String)" ").join((Object[])stringArray));
    }

    public void mkdirIfNotExists(String string) throws JSchException, SftpException, SshException {
        if (!this.exists(string)) {
            this.mkdir(string);
        }
    }

    public void write(String string, String string2) {
    }
}

