/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplane;

import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Set;
import nl.sascom.backplane.Resource;
import nl.sascom.backplane.ResourceTracker;

public class ResourceManager {
    private final Set<ResourceTracker> resourceTrackers = new LinkedHashSet<ResourceTracker>();

    public void addResourceTracker(ResourceTracker resourceTracker) {
        this.resourceTrackers.add(resourceTracker);
    }

    public <T> T getResourceTracker(Class<T> clazz) {
        for (ResourceTracker resourceTracker : this.resourceTrackers) {
            if (resourceTracker.getClass() != clazz) continue;
            return (T)resourceTracker;
        }
        return null;
    }

    public <T extends AutoCloseable> T createResource(Object object, Class<T> clazz) {
        Resource<AutoCloseable> resource = new Resource<AutoCloseable>(this, clazz, (AutoCloseable)object);
        AutoCloseable autoCloseable = (AutoCloseable)Proxy.newProxyInstance(object.getClass().getClassLoader(), new Class[]{clazz}, resource);
        for (ResourceTracker resourceTracker : this.resourceTrackers) {
            resourceTracker.track(resource);
        }
        return (T)autoCloseable;
    }

    public <T extends AutoCloseable> void closeResource(Resource<T> resource) {
        for (ResourceTracker resourceTracker : this.resourceTrackers) {
            resourceTracker.untrack(resource);
        }
    }
}

