/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplane;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import nl.sascom.backplane.Resource;
import nl.sascom.backplane.ResourceListener;
import nl.sascom.backplane.ResourceTracker;
import nl.sascom.backplanepublic.common.listeners.InitialListenerTrigger;
import nl.sascom.backplanepublic.common.listeners.ListenerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountingResourceTracker
implements ResourceTracker,
InitialListenerTrigger<ResourceListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CountingResourceTracker.class);
    private final Map<Class<?>, AtomicLong> resources = new HashMap();
    private final ListenerManager listenerManager = new ListenerManager();

    public CountingResourceTracker(boolean bl) {
        if (bl) {
            new Timer().scheduleAtFixedRate(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map<Class<?>, AtomicLong> map = CountingResourceTracker.this.resources;
                    synchronized (map) {
                        for (Map.Entry<Class<?>, AtomicLong> entry : CountingResourceTracker.this.resources.entrySet()) {
                            long l = entry.getValue().get();
                            if (l <= 0L) continue;
                            LOGGER.info(entry.getKey().getName() + ": " + l);
                        }
                    }
                }
            }, 0L, 10000L);
        }
        this.listenerManager.registerInitialTrigger(ResourceListener.class, this);
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public Map<Class<?>, AtomicLong> getResources() {
        return this.resources;
    }

    @Override
    public void triggerForListener(ResourceListener resourceListener) {
        for (Map.Entry<Class<?>, AtomicLong> entry : this.resources.entrySet()) {
            resourceListener.resourceUpdate(entry.getKey().getName(), entry.getValue().get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void track(Resource resource) {
        AtomicLong atomicLong = null;
        CountingResourceTracker countingResourceTracker = this;
        synchronized (countingResourceTracker) {
            atomicLong = this.resources.get(resource.getInterfaceClass());
            if (atomicLong == null) {
                atomicLong = new AtomicLong();
                this.resources.put(resource.getInterfaceClass(), atomicLong);
            }
            long l = atomicLong.incrementAndGet();
            this.listenerManager.trigger(ResourceListener.class).resourceUpdate(resource.getInterfaceClass().getName(), l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void untrack(Resource resource) {
        Class<?> clazz = resource.getInterfaceClass();
        AtomicLong atomicLong = null;
        CountingResourceTracker countingResourceTracker = this;
        synchronized (countingResourceTracker) {
            atomicLong = this.resources.get(clazz);
            if (atomicLong == null) {
                atomicLong = new AtomicLong();
                this.resources.put(clazz, atomicLong);
            }
            long l = atomicLong.decrementAndGet();
            this.listenerManager.trigger(ResourceListener.class).resourceUpdate(clazz.getName(), l);
        }
    }
}

