/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common.metrics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongBinaryOperator;
import nl.sascom.backplanepublic.common.MetricType;
import nl.sascom.backplanepublic.common.Response;
import nl.sascom.backplanepublic.common.metrics.AccumulatingLongMetric;
import nl.sascom.backplanepublic.common.metrics.ByteSizeMetric;
import nl.sascom.backplanepublic.common.metrics.IntegerMetric;
import nl.sascom.backplanepublic.common.metrics.LongMetric;
import nl.sascom.backplanepublic.common.metrics.MetricChild;
import nl.sascom.backplanepublic.common.metrics.MetricParent;
import nl.sascom.backplanepublic.common.metrics.Metrics;
import nl.sascom.backplanepublic.common.metrics.RequestContextInterface;
import nl.sascom.backplanepublic.common.metrics.StringMetric;
import nl.sascom.backplanepublic.common.metrics.TimeSpanMetric;

public class MetricGroup
implements MetricParent,
MetricChild {
    private final String id;
    private final String label;
    private final Map<String, MetricChild> metrics = Collections.synchronizedMap(new HashMap());
    private final RequestContextInterface requestContext;
    private final MetricParent parent;

    public MetricGroup(MetricParent metricParent, RequestContextInterface requestContextInterface, String string, String string2) {
        this.parent = metricParent;
        this.requestContext = requestContextInterface;
        this.id = string;
        this.label = string2;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Iterable<MetricChild> getMetrics() {
        return this.metrics.values();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public IntegerMetric addIntegerMetric(String string, String string2) {
        return this.add(new IntegerMetric(this.requestContext, this, string, string2));
    }

    public TimeSpanMetric addTimeSpanMetric(String string, String string2) {
        return this.add(new TimeSpanMetric(this.requestContext, this, string, string2));
    }

    public StringMetric addStringMetricType(String string, String string2) {
        return this.add(new StringMetric(this.requestContext, this, string, string2));
    }

    public LongMetric addLongMetricType(String string, String string2) {
        return this.add(new LongMetric(this.requestContext, this, string, string2));
    }

    public AccumulatingLongMetric addAccumulatingLongMetricType(String string, String string2, LongBinaryOperator longBinaryOperator) {
        return this.add(new AccumulatingLongMetric(this.requestContext, this, string, string2, longBinaryOperator));
    }

    public ByteSizeMetric addByteSizeMetric(String string, String string2, LongBinaryOperator longBinaryOperator) {
        return this.add(new ByteSizeMetric(this.requestContext, this, string, string2, longBinaryOperator));
    }

    public <T extends MetricChild> T add(T t) {
        this.metrics.put(t.getId(), t);
        return t;
    }

    public MetricGroup addGroup(String string, String string2) {
        return this.add(new MetricGroup(this, this.requestContext, string, string2));
    }

    @Override
    public int getOrder(MetricChild metricChild) {
        return 0;
    }

    @Override
    public ObjectNode toJson() {
        ObjectNode objectNode = Response.createObject();
        ArrayNode arrayNode = Response.createArray();
        objectNode.put("id", this.id);
        objectNode.put("path", this.getPath());
        objectNode.put("label", this.label);
        if (this.parent != null) {
            objectNode.put("order", this.parent.getOrder(this));
        }
        objectNode.put("type", MetricType.GROUP.name());
        objectNode.set("children", (JsonNode)arrayNode);
        for (MetricChild metricChild : this.metrics.values()) {
            arrayNode.add((JsonNode)metricChild.toJson());
        }
        return objectNode;
    }

    @Override
    public String getPath() {
        if (this.parent == null || this.parent instanceof Metrics) {
            return this.id;
        }
        return this.parent.getId() + "." + this.id;
    }

    public MetricChild getMetric(String string) {
        return this.metrics.get(string);
    }
}

