/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplane.appbase.library.ssh;

import java.util.concurrent.TimeUnit;

public class SshSettings {
    public static SshSettings DEFAULT = new SshSettings();
    public final boolean wait;
    public final boolean allowNonZeroExitState;
    public final int maxRetries;
    public final boolean logOutput;
    public final boolean logError;
    public final boolean logInfo;
    private String defaultAnswer;
    private long timeOut = 10L;
    private TimeUnit timeoutTimeUnit = TimeUnit.MINUTES;

    private SshSettings() {
        this.wait = true;
        this.allowNonZeroExitState = false;
        this.maxRetries = 0;
        this.logOutput = true;
        this.logError = true;
        this.logInfo = true;
    }

    private SshSettings(boolean bl, boolean bl2, int n, boolean bl3, boolean bl4, boolean bl5, long l, TimeUnit timeUnit) {
        this.wait = bl;
        this.allowNonZeroExitState = bl2;
        this.maxRetries = n;
        this.logOutput = bl3;
        this.logError = bl4;
        this.logInfo = bl5;
        this.timeOut = l;
        this.timeoutTimeUnit = timeUnit;
    }

    public SshSettings maxRetries(int n) {
        return new SshSettings(this.wait, this.allowNonZeroExitState, n, this.logOutput, this.logError, this.logInfo, this.timeOut, this.timeoutTimeUnit);
    }

    public SshSettings logOutput(boolean bl) {
        return new SshSettings(this.wait, this.allowNonZeroExitState, this.maxRetries, bl, this.logError, this.logInfo, this.timeOut, this.timeoutTimeUnit);
    }

    public SshSettings logError(boolean bl) {
        return new SshSettings(this.wait, this.allowNonZeroExitState, this.maxRetries, this.logOutput, bl, this.logInfo, this.timeOut, this.timeoutTimeUnit);
    }

    public SshSettings allowNonZeroExitState(boolean bl) {
        return new SshSettings(this.wait, bl, this.maxRetries, this.logOutput, this.logError, this.logInfo, this.timeOut, this.timeoutTimeUnit);
    }

    public SshSettings logInfo(boolean bl) {
        return new SshSettings(this.wait, this.allowNonZeroExitState, this.maxRetries, this.logOutput, this.logError, bl, this.timeOut, this.timeoutTimeUnit);
    }

    public String getDefaultAnswer() {
        return this.defaultAnswer;
    }

    public SshSettings setDefaultAnswer(String string) {
        SshSettings sshSettings = new SshSettings(this.wait, this.allowNonZeroExitState, this.maxRetries, this.logOutput, this.logError, this.logInfo, this.timeOut, this.timeoutTimeUnit);
        sshSettings.defaultAnswer = string;
        return sshSettings;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public TimeUnit getTimeOutUnit() {
        return this.timeoutTimeUnit;
    }

    public SshSettings timeOut(int n, TimeUnit timeUnit) {
        SshSettings sshSettings = new SshSettings(this.wait, this.allowNonZeroExitState, this.maxRetries, this.logOutput, this.logError, this.logInfo, n, timeUnit);
        sshSettings.setTimeOut(n, timeUnit);
        return sshSettings;
    }

    private void setTimeOut(int n, TimeUnit timeUnit) {
        this.timeOut = n;
        this.timeoutTimeUnit = timeUnit;
    }
}

