/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.node.common.utils;

import com.google.common.base.Charsets;
import com.google.common.primitives.Longs;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianDataOutputStream
extends OutputStream {
    private final OutputStream outputStream;
    private long bytesWritten = 0L;

    public LittleEndianDataOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public LittleEndianDataOutputStream() {
        this.outputStream = null;
    }

    public long pos() {
        return this.bytesWritten;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.outputStream.write(byArray, n, n2);
        this.bytesWritten += (long)n2;
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeFloatUnchecked(float f) throws IOException {
        this.writeIntUnchecked(Float.floatToIntBits(f));
    }

    public void writeInt(int n) throws IOException {
        this.outputStream.write(0xFF & n);
        this.outputStream.write(0xFF & n >> 8);
        this.outputStream.write(0xFF & n >> 16);
        this.outputStream.write(0xFF & n >> 24);
        this.bytesWritten += 4L;
    }

    public void writeIntUnchecked(int n) throws IOException {
        this.outputStream.write(0xFF & n);
        this.outputStream.write(0xFF & n >> 8);
        this.outputStream.write(0xFF & n >> 16);
        this.outputStream.write(0xFF & n >> 24);
        this.bytesWritten += 4L;
    }

    public void writeLong(long l) throws IOException {
        byte[] byArray = Longs.toByteArray((long)Long.reverseBytes(l));
        this.write(byArray, 0, byArray.length);
    }

    public void writeShort(short s) throws IOException {
        this.outputStream.write(0xFF & s);
        this.outputStream.write(0xFF & s >> 8);
        this.bytesWritten += 2L;
    }

    public void writeUTF(String string) throws IOException {
        new DataOutputStream(this.outputStream).writeUTF(string);
        this.bytesWritten += (long)(string.getBytes(Charsets.UTF_8).length + 2);
    }

    @Override
    public void write(int n) throws IOException {
        this.outputStream.write(n);
        ++this.bytesWritten;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.outputStream.write(byArray);
        this.bytesWritten += (long)byArray.length;
    }

    public void reset() {
    }

    public void writeByte(byte by) throws IOException {
        this.outputStream.write(by);
        ++this.bytesWritten;
    }

    public void ensureExtraCapacity(int n) {
    }

    public void writeDoubleUnchecked(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeLongUnchecked(long l) throws IOException {
        byte[] byArray = Longs.toByteArray((long)Long.reverseBytes(l));
        this.write(byArray, 0, byArray.length);
    }

    public void writeShortUnchecked(short s) throws IOException {
        this.outputStream.write(0xFF & s);
        this.outputStream.write(0xFF & s >> 8);
        this.bytesWritten += 2L;
    }

    public void writeUnchecked(byte[] byArray, int n, int n2) throws IOException {
        this.outputStream.write(byArray, n, n2);
        this.bytesWritten += (long)n2;
    }

    public void writeByte(int n) throws IOException {
        this.outputStream.write(n);
        ++this.bytesWritten;
    }

    public void writeByteUnchecked(int n) throws IOException {
        this.outputStream.write(n);
        ++this.bytesWritten;
    }

    public void align8() throws IOException {
        long l = 8L - this.bytesWritten % 8L;
        if (l > 0L && l != 8L) {
            this.write(new byte[(int)l]);
        }
    }

    public void align4() throws IOException {
        long l = 4L - this.bytesWritten % 4L;
        if (l > 0L && l != 4L) {
            this.write(new byte[(int)l]);
        }
    }
}

