/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.geometry.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import nl.bimbase.geometry.types.Matrix;
import nl.bimbase.geometry.types.Matrix3d;
import nl.bimbase.geometry.types.Vector3d;

public class Matrix4d {
    private static final double EPSILON = 1.0E-6;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final Matrix4d IDENTITY = new Matrix4d();
    public double[] matrix;
    private FloatBuffer floatBuffer;

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.matrix);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Matrix4d matrix4d = (Matrix4d)object;
        return Arrays.equals(this.matrix, matrix4d.matrix);
    }

    public Matrix4d() {
        this.matrix = new double[16];
        Matrix.setIdentityM(this.matrix, 0);
    }

    public Matrix4d(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16) {
        this.matrix = new double[]{d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16};
    }

    public static Matrix4d create(double[] dArray) {
        return new Matrix4d(dArray);
    }

    public Matrix4d(double[] dArray) {
        this.matrix = dArray;
    }

    public double[] multiply(double d, double d2, double d3) {
        double[] dArray = new double[]{this.matrix[0] * d + this.matrix[4] * d2 + this.matrix[8] * d3 + this.matrix[12] * 1.0, this.matrix[1] * d + this.matrix[5] * d2 + this.matrix[9] * d3 + this.matrix[13] * 1.0, this.matrix[2] * d + this.matrix[6] * d2 + this.matrix[10] * d3 + this.matrix[14] * 1.0, this.matrix[3] * d + this.matrix[7] * d2 + this.matrix[11] * d3 + this.matrix[15] * 1.0};
        return dArray;
    }

    public double[] transform(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = this.matrix[3] * d + this.matrix[7] * d2 + this.matrix[11] * d3 + this.matrix[15];
        double[] dArray2 = new double[]{(this.matrix[0] * d + this.matrix[4] * d2 + this.matrix[8] * d3 + this.matrix[12]) / d4, (this.matrix[1] * d + this.matrix[5] * d2 + this.matrix[9] * d3 + this.matrix[13]) / d4, (this.matrix[2] * d + this.matrix[6] * d2 + this.matrix[10] * d3 + this.matrix[14]) / d4};
        return dArray2;
    }

    public double[] multiply(double[] dArray, double d, double d2, double d3) {
        dArray[0] = this.matrix[0] * d + this.matrix[4] * d2 + this.matrix[8] * d3 + this.matrix[12] * 1.0;
        dArray[1] = this.matrix[1] * d + this.matrix[5] * d2 + this.matrix[9] * d3 + this.matrix[13] * 1.0;
        dArray[2] = this.matrix[2] * d + this.matrix[6] * d2 + this.matrix[10] * d3 + this.matrix[14] * 1.0;
        return dArray;
    }

    public Matrix4d multiply(Matrix4d matrix4d) {
        Matrix4d matrix4d2 = new Matrix4d();
        Matrix.multiplyMM(matrix4d2.matrix, 0, this.matrix, 0, matrix4d.matrix, 0);
        return matrix4d2;
    }

    public Matrix4d multiply(Matrix4d matrix4d, Matrix4d matrix4d2) {
        Matrix4d matrix4d3 = new Matrix4d();
        Matrix.multiplyMM(matrix4d3.matrix, 0, this.matrix, 0, matrix4d2.matrix, 0);
        return matrix4d3;
    }

    public Matrix4d scaleInline(double d, double d2, double d3) {
        int n = 0;
        while (n < 4) {
            int n2;
            int n3 = n2 = n++;
            this.matrix[n3] = this.matrix[n3] * d;
            int n4 = 4 + n2;
            this.matrix[n4] = this.matrix[n4] * d2;
            int n5 = 8 + n2;
            this.matrix[n5] = this.matrix[n5] * d3;
        }
        return this;
    }

    public Matrix4d scale(double d, double d2, double d3) {
        Matrix4d matrix4d = this.copy();
        for (int i = 0; i < 4; ++i) {
            int n = i;
            matrix4d.matrix[n] = matrix4d.matrix[n] * d;
            int n2 = 4 + i;
            matrix4d.matrix[n2] = matrix4d.matrix[n2] * d2;
            int n3 = 8 + i;
            matrix4d.matrix[n3] = matrix4d.matrix[n3] * d3;
        }
        return matrix4d;
    }

    public void translateInline(double d, double d2, double d3) {
        for (int i = 0; i < 4; ++i) {
            this.matrix[12 + i] = this.matrix[i] * d + this.matrix[4 + i] * d2 + this.matrix[8 + i] * d3 + this.matrix[12 + i];
        }
        this.floatBuffer = null;
    }

    public boolean hasNaN() {
        for (int i = 0; i < 16; ++i) {
            if (!Double.isNaN(this.matrix[i])) continue;
            return true;
        }
        return false;
    }

    public JsonNode toJson() {
        ArrayNode arrayNode = OBJECT_MAPPER.createArrayNode();
        for (int i = 0; i < 16; ++i) {
            arrayNode.add(this.matrix[i]);
        }
        return arrayNode;
    }

    public Matrix4d invert() {
        Matrix4d matrix4d = new Matrix4d();
        Matrix.invertM(matrix4d.matrix, 0, this.matrix, 0);
        return matrix4d;
    }

    public static Matrix4d fromJson(ArrayNode arrayNode) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.matrix = new double[16];
        for (int i = 0; i < 16; ++i) {
            matrix4d.matrix[i] = arrayNode.get(i).asDouble();
        }
        return matrix4d;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            stringBuilder.append(this.matrix[i]);
            if ((i + 1) % 4 == 0) {
                stringBuilder.append("\n");
                continue;
            }
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public byte[] toBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(128).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < 16; ++i) {
            byteBuffer.putDouble(this.matrix[i]);
        }
        return byteBuffer.array();
    }

    public static Matrix4d read(DataInput dataInput) throws IOException {
        Matrix4d matrix4d = new Matrix4d();
        byte[] byArray = new byte[128];
        dataInput.readFully(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < 16; ++i) {
            matrix4d.matrix[i] = byteBuffer.getDouble();
        }
        return matrix4d;
    }

    public static Matrix4d read(ByteBuffer byteBuffer) throws IOException {
        Matrix4d matrix4d = new Matrix4d();
        for (int i = 0; i < 16; ++i) {
            matrix4d.matrix[i] = byteBuffer.getDouble();
        }
        return matrix4d;
    }

    public Matrix4d copy() {
        double[] dArray = new double[16];
        System.arraycopy(this.matrix, 0, dArray, 0, 16);
        return new Matrix4d(dArray);
    }

    public Matrix4d translate(double d, double d2, double d3) {
        Matrix4d matrix4d = this.copy();
        Matrix.translateM(matrix4d.matrix, 0, d, d2, d3);
        return matrix4d;
    }

    public Matrix4d translate(Vector3d vector3d) {
        Matrix4d matrix4d = this.copy();
        Matrix.translateM(matrix4d.matrix, 0, vector3d.getX(), vector3d.getY(), vector3d.getZ());
        return matrix4d;
    }

    public void multiply(double[] dArray, double[] dArray2) {
        Matrix.multiplyMV(dArray, 0, this.matrix, 0, dArray2, 0);
    }

    public void multiply(float[] fArray, float[] fArray2) {
        Matrix.multiplyMV(fArray, 0, this.matrix, 0, fArray2, 0);
    }

    public boolean isOk() {
        for (double d : this.matrix) {
            if (!Double.isInfinite(d) && !Double.isNaN(d)) continue;
            return false;
        }
        return true;
    }

    public String to2dSpacedString(double d) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.scaleInline(d, d, d);
        return matrix4d.multiply(this).to2dSpacedString();
    }

    public String to2dSpacedString() {
        return this.matrix[0] + " " + this.matrix[1] + " " + this.matrix[4] + " " + this.matrix[5] + " " + this.matrix[12] + " " + this.matrix[13];
    }

    public double[] to2DMatrix() {
        return new double[]{this.matrix[0], this.matrix[1], this.matrix[4], this.matrix[5], this.matrix[12], this.matrix[13]};
    }

    public double[] to2DMatrix(double d) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.scaleInline(d, d, d);
        return matrix4d.multiply(this).to2DMatrix();
    }

    public Matrix3d toMatrix3d() {
        Matrix3d matrix3d = new Matrix3d(new double[]{this.matrix[0], this.matrix[1], this.matrix[2], this.matrix[4], this.matrix[5], this.matrix[6], this.matrix[12], this.matrix[13], 1.0});
        return matrix3d;
    }

    public Matrix3d toMatrix3dAlt() {
        Matrix3d matrix3d = new Matrix3d(new double[]{this.matrix[0], this.matrix[1], this.matrix[2], this.matrix[4], this.matrix[5], this.matrix[6], this.matrix[8], this.matrix[9], this.matrix[10]});
        return matrix3d;
    }

    public Matrix3d toMatrix3dAlt2() {
        Matrix3d matrix3d = new Matrix3d(new double[]{this.matrix[0], this.matrix[1], this.matrix[2], this.matrix[4], this.matrix[5], this.matrix[6], 0.0, 0.0, 1.0});
        return matrix3d;
    }

    public double get(int n) {
        return this.matrix[n];
    }

    public void multiply(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray.length == 4 ? dArray[3] : 1.0;
        dArray[0] = this.matrix[0] * d + this.matrix[4] * d2 + this.matrix[8] * d3 + this.matrix[12] * d4;
        dArray[1] = this.matrix[1] * d + this.matrix[5] * d2 + this.matrix[9] * d3 + this.matrix[13] * d4;
        dArray[2] = this.matrix[2] * d + this.matrix[6] * d2 + this.matrix[10] * d3 + this.matrix[14] * d4;
        if (dArray.length == 4) {
            dArray[3] = this.matrix[3] * d + this.matrix[7] * d2 + this.matrix[11] * d3 + this.matrix[15] * d4;
        }
    }

    public FloatBuffer asFloatBuffer() {
        if (this.floatBuffer == null) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(64).order(ByteOrder.LITTLE_ENDIAN);
            for (double d : this.matrix) {
                byteBuffer.putFloat((float)d);
            }
            this.floatBuffer = byteBuffer.position(0).asFloatBuffer();
        }
        return this.floatBuffer;
    }

    public void reset() {
        this.floatBuffer = null;
    }

    private double hypot(double d, double d2, double d3) {
        return Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0) + Math.pow(d3, 2.0));
    }

    public void lookAt(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        double d;
        double d2;
        double d3 = vector3d.getX();
        double d4 = vector3d.getY();
        double d5 = vector3d.getZ();
        double d6 = vector3d3.getX();
        double d7 = vector3d3.getY();
        double d8 = vector3d3.getZ();
        double d9 = vector3d2.getX();
        double d10 = vector3d2.getY();
        double d11 = vector3d2.getZ();
        if (Math.abs(d3 - d9) < 1.0E-6 && Math.abs(d4 - d10) < 1.0E-6 && Math.abs(d5 - d11) < 1.0E-6) {
            Matrix.setIdentityM(this.matrix, 0);
            return;
        }
        double d12 = d3 - d9;
        double d13 = d4 - d10;
        double d14 = d5 - d11;
        double d15 = 1.0 / this.hypot(d12, d13, d14);
        double d16 = d7 * (d14 *= d15) - d8 * (d13 *= d15);
        if ((d15 = this.hypot(d16, d2 = d8 * (d12 *= d15) - d6 * d14, d = d6 * d13 - d7 * d12)) == 0.0) {
            d16 = 0.0;
            d2 = 0.0;
            d = 0.0;
        } else {
            d15 = 1.0 / d15;
            d16 *= d15;
            d2 *= d15;
            d *= d15;
        }
        double d17 = d13 * d - d14 * d2;
        double d18 = d14 * d16 - d12 * d;
        double d19 = d12 * d2 - d13 * d16;
        d15 = this.hypot(d17, d18, d19);
        if (d15 == 0.0) {
            d17 = 0.0;
            d18 = 0.0;
            d19 = 0.0;
        } else {
            d15 = 1.0 / d15;
            d17 *= d15;
            d18 *= d15;
            d19 *= d15;
        }
        this.matrix[0] = d16;
        this.matrix[1] = d17;
        this.matrix[2] = d12;
        this.matrix[3] = 0.0;
        this.matrix[4] = d2;
        this.matrix[5] = d18;
        this.matrix[6] = d13;
        this.matrix[7] = 0.0;
        this.matrix[8] = d;
        this.matrix[9] = d19;
        this.matrix[10] = d14;
        this.matrix[11] = 0.0;
        this.matrix[12] = -(d16 * d3 + d2 * d4 + d * d5);
        this.matrix[13] = -(d17 * d3 + d18 * d4 + d19 * d5);
        this.matrix[14] = -(d12 * d3 + d13 * d4 + d14 * d5);
        this.matrix[15] = 1.0;
        this.floatBuffer = null;
    }

    public void identity() {
        Matrix.setIdentityM(this.matrix, 0);
        this.floatBuffer = null;
    }

    public void rotateInline(double d, double d2, double d3, double d4) {
        Matrix.rotateM(this.matrix, 0, d, d2, d3, d4);
        this.floatBuffer = null;
    }

    public boolean isIdentity() {
        return this.equals(IDENTITY);
    }

    public Matrix4d resetTranslation() {
        Matrix4d matrix4d = this.copy();
        matrix4d.matrix[12] = 0.0;
        matrix4d.matrix[13] = 0.0;
        matrix4d.matrix[14] = 0.0;
        return matrix4d;
    }

    public Vector3d extractScale() {
        return new Vector3d(new Vector3d(this.matrix[0], this.matrix[1], this.matrix[2]).length(), new Vector3d(this.matrix[4], this.matrix[5], this.matrix[6]).length(), new Vector3d(this.matrix[8], this.matrix[9], this.matrix[10]).length());
    }

    public Matrix4d extractRotationMatrix() {
        Vector3d vector3d = this.extractScale();
        return new Matrix4d(this.matrix[0] / vector3d.get(0), this.matrix[1] / vector3d.get(0), this.matrix[2] / vector3d.get(0), 0.0, this.matrix[4] / vector3d.get(1), this.matrix[5] / vector3d.get(1), this.matrix[6] / vector3d.get(1), 0.0, this.matrix[8] / vector3d.get(2), this.matrix[9] / vector3d.get(2), this.matrix[10] / vector3d.get(2), 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public void resetTranslationInline() {
        this.matrix[12] = 0.0;
        this.matrix[13] = 0.0;
        this.matrix[14] = 0.0;
    }

    public boolean isNoRotation() {
        return this.matrix[0] == 1.0 && this.matrix[1] == 0.0 && this.matrix[2] == 0.0 && this.matrix[3] == 0.0 && this.matrix[4] == 0.0 && this.matrix[5] == 1.0 && this.matrix[6] == 0.0 && this.matrix[7] == 0.0 && this.matrix[8] == 0.0 && this.matrix[9] == 0.0 && this.matrix[10] == 1.0 && this.matrix[11] == 0.0;
    }

    public boolean isOnly270Rotation() {
        return this.matrix[0] == -1.0 && this.matrix[1] == 0.0 && this.matrix[2] == 0.0 && this.matrix[3] == 0.0 && this.matrix[4] == 0.0 && this.matrix[5] == -1.0 && this.matrix[6] == 0.0 && this.matrix[7] == 0.0 && this.matrix[8] == 0.0 && this.matrix[9] == 0.0 && this.matrix[10] == 1.0 && this.matrix[11] == 0.0;
    }

    public boolean isOnly180Rotation() {
        return this.matrix[0] == 0.0 && this.matrix[1] == 1.0 && this.matrix[2] == 0.0 && this.matrix[3] == 0.0 && this.matrix[4] == -1.0 && this.matrix[5] == 0.0 && this.matrix[6] == 0.0 && this.matrix[7] == 0.0 && this.matrix[8] == 0.0 && this.matrix[9] == 0.0 && this.matrix[10] == 1.0 && this.matrix[11] == 0.0;
    }

    public boolean isOnly90Rotation() {
        return this.matrix[0] == 0.0 && this.matrix[1] == -1.0 && this.matrix[2] == 0.0 && this.matrix[3] == 0.0 && this.matrix[4] == 1.0 && this.matrix[5] == 0.0 && this.matrix[6] == 0.0 && this.matrix[7] == 0.0 && this.matrix[8] == 0.0 && this.matrix[9] == 0.0 && this.matrix[10] == 1.0 && this.matrix[11] == 0.0;
    }

    public boolean hasNonZRotations() {
        return this.matrix[2] != 0.0 || this.matrix[6] != 0.0 || this.matrix[8] != 0.0 || this.matrix[9] != 0.0 || this.matrix[10] != 1.0;
    }
}

