/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.geometry.types;

import java.util.Arrays;

public class Matrix {
    private static final float[] sTemp = new float[32];
    private static final double[] sTempD = new double[32];

    public static void main(String[] stringArray) {
        float[] fArray = new float[16];
        Matrix.setIdentityM(fArray, 0);
        Matrix.translateM(fArray, 0, 2.0f, 3.0f, 4.0f);
        Matrix.dump(fArray);
    }

    public static void multiplyMM(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        fArray[n + 0] = fArray3[0] * fArray2[0] + fArray3[1] * fArray2[4] + fArray3[2] * fArray2[8] + fArray3[3] * fArray2[12];
        fArray[n + 1] = fArray3[0] * fArray2[1] + fArray3[1] * fArray2[5] + fArray3[2] * fArray2[9] + fArray3[3] * fArray2[13];
        fArray[n + 2] = fArray3[0] * fArray2[2] + fArray3[1] * fArray2[6] + fArray3[2] * fArray2[10] + fArray3[3] * fArray2[14];
        fArray[n + 3] = fArray3[0] * fArray2[3] + fArray3[1] * fArray2[7] + fArray3[2] * fArray2[11] + fArray3[3] * fArray2[15];
        fArray[n + 4] = fArray3[4] * fArray2[0] + fArray3[5] * fArray2[4] + fArray3[6] * fArray2[8] + fArray3[7] * fArray2[12];
        fArray[n + 5] = fArray3[4] * fArray2[1] + fArray3[5] * fArray2[5] + fArray3[6] * fArray2[9] + fArray3[7] * fArray2[13];
        fArray[n + 6] = fArray3[4] * fArray2[2] + fArray3[5] * fArray2[6] + fArray3[6] * fArray2[10] + fArray3[7] * fArray2[14];
        fArray[n + 7] = fArray3[4] * fArray2[3] + fArray3[5] * fArray2[7] + fArray3[6] * fArray2[11] + fArray3[7] * fArray2[15];
        fArray[n + 8] = fArray3[8] * fArray2[0] + fArray3[9] * fArray2[4] + fArray3[10] * fArray2[8] + fArray3[11] * fArray2[12];
        fArray[n + 9] = fArray3[8] * fArray2[1] + fArray3[9] * fArray2[5] + fArray3[10] * fArray2[9] + fArray3[11] * fArray2[13];
        fArray[n + 10] = fArray3[8] * fArray2[2] + fArray3[9] * fArray2[6] + fArray3[10] * fArray2[10] + fArray3[11] * fArray2[14];
        fArray[n + 11] = fArray3[8] * fArray2[3] + fArray3[9] * fArray2[7] + fArray3[10] * fArray2[11] + fArray3[11] * fArray2[15];
        fArray[n + 12] = fArray3[12] * fArray2[0] + fArray3[13] * fArray2[4] + fArray3[14] * fArray2[8] + fArray3[15] * fArray2[12];
        fArray[n + 13] = fArray3[12] * fArray2[1] + fArray3[13] * fArray2[5] + fArray3[14] * fArray2[9] + fArray3[15] * fArray2[13];
        fArray[n + 14] = fArray3[12] * fArray2[2] + fArray3[13] * fArray2[6] + fArray3[14] * fArray2[10] + fArray3[15] * fArray2[14];
        fArray[n + 15] = fArray3[12] * fArray2[3] + fArray3[13] * fArray2[7] + fArray3[14] * fArray2[11] + fArray3[15] * fArray2[15];
    }

    public static void multiplyMM(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        dArray[n + 0] = dArray3[0] * dArray2[0] + dArray3[1] * dArray2[4] + dArray3[2] * dArray2[8] + dArray3[3] * dArray2[12];
        dArray[n + 1] = dArray3[0] * dArray2[1] + dArray3[1] * dArray2[5] + dArray3[2] * dArray2[9] + dArray3[3] * dArray2[13];
        dArray[n + 2] = dArray3[0] * dArray2[2] + dArray3[1] * dArray2[6] + dArray3[2] * dArray2[10] + dArray3[3] * dArray2[14];
        dArray[n + 3] = dArray3[0] * dArray2[3] + dArray3[1] * dArray2[7] + dArray3[2] * dArray2[11] + dArray3[3] * dArray2[15];
        dArray[n + 4] = dArray3[4] * dArray2[0] + dArray3[5] * dArray2[4] + dArray3[6] * dArray2[8] + dArray3[7] * dArray2[12];
        dArray[n + 5] = dArray3[4] * dArray2[1] + dArray3[5] * dArray2[5] + dArray3[6] * dArray2[9] + dArray3[7] * dArray2[13];
        dArray[n + 6] = dArray3[4] * dArray2[2] + dArray3[5] * dArray2[6] + dArray3[6] * dArray2[10] + dArray3[7] * dArray2[14];
        dArray[n + 7] = dArray3[4] * dArray2[3] + dArray3[5] * dArray2[7] + dArray3[6] * dArray2[11] + dArray3[7] * dArray2[15];
        dArray[n + 8] = dArray3[8] * dArray2[0] + dArray3[9] * dArray2[4] + dArray3[10] * dArray2[8] + dArray3[11] * dArray2[12];
        dArray[n + 9] = dArray3[8] * dArray2[1] + dArray3[9] * dArray2[5] + dArray3[10] * dArray2[9] + dArray3[11] * dArray2[13];
        dArray[n + 10] = dArray3[8] * dArray2[2] + dArray3[9] * dArray2[6] + dArray3[10] * dArray2[10] + dArray3[11] * dArray2[14];
        dArray[n + 11] = dArray3[8] * dArray2[3] + dArray3[9] * dArray2[7] + dArray3[10] * dArray2[11] + dArray3[11] * dArray2[15];
        dArray[n + 12] = dArray3[12] * dArray2[0] + dArray3[13] * dArray2[4] + dArray3[14] * dArray2[8] + dArray3[15] * dArray2[12];
        dArray[n + 13] = dArray3[12] * dArray2[1] + dArray3[13] * dArray2[5] + dArray3[14] * dArray2[9] + dArray3[15] * dArray2[13];
        dArray[n + 14] = dArray3[12] * dArray2[2] + dArray3[13] * dArray2[6] + dArray3[14] * dArray2[10] + dArray3[15] * dArray2[14];
        dArray[n + 15] = dArray3[12] * dArray2[3] + dArray3[13] * dArray2[7] + dArray3[14] * dArray2[11] + dArray3[15] * dArray2[15];
    }

    public static float[] multiplyV(float[] fArray, float[] fArray2) {
        if (fArray2.length == 3) {
            float[] fArray3 = new float[4];
            Matrix.multiplyMV(fArray3, 0, fArray, 0, new float[]{fArray2[0], fArray2[1], fArray2[2], 0.0f}, 0);
            return new float[]{fArray3[0], fArray3[1], fArray3[2]};
        }
        if (fArray2.length == 4) {
            float[] fArray4 = new float[4];
            Matrix.multiplyMV(fArray4, 0, fArray, 0, new float[]{fArray2[0], fArray2[1], fArray2[2], fArray2[3]}, 0);
            return fArray4;
        }
        return null;
    }

    public static double[] multiplyV(double[] dArray, double[] dArray2) {
        if (dArray2.length == 3) {
            double[] dArray3 = new double[4];
            Matrix.multiplyMV(dArray3, 0, dArray, 0, new double[]{dArray2[0], dArray2[1], dArray2[2], 0.0}, 0);
            return new double[]{dArray3[0], dArray3[1], dArray3[2]};
        }
        if (dArray2.length == 4) {
            double[] dArray4 = new double[4];
            Matrix.multiplyMV(dArray4, 0, dArray, 0, new double[]{dArray2[0], dArray2[1], dArray2[2], dArray2[3]}, 0);
            return dArray4;
        }
        return null;
    }

    public static void multiplyMV(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        fArray[n + 0] = fArray2[n2 + 0] * fArray3[n3 + 0] + fArray2[n2 + 4] * fArray3[n3 + 1] + fArray2[n2 + 8] * fArray3[n3 + 2] + fArray2[n2 + 12] * fArray3[n3 + 3];
        fArray[n + 1] = fArray2[n2 + 1] * fArray3[n3 + 0] + fArray2[n2 + 5] * fArray3[n3 + 1] + fArray2[n2 + 9] * fArray3[n3 + 2] + fArray2[n2 + 13] * fArray3[n3 + 3];
        fArray[n + 2] = fArray2[n2 + 2] * fArray3[n3 + 0] + fArray2[n2 + 6] * fArray3[n3 + 1] + fArray2[n2 + 10] * fArray3[n3 + 2] + fArray2[n2 + 14] * fArray3[n3 + 3];
        fArray[n + 3] = fArray2[n2 + 3] * fArray3[n3 + 0] + fArray2[n2 + 7] * fArray3[n3 + 1] + fArray2[n2 + 11] * fArray3[n3 + 2] + fArray2[n2 + 15] * fArray3[n3 + 3];
    }

    public static void multiplyMV(float[] fArray, int n, double[] dArray, int n2, double[] dArray2, int n3) {
        fArray[n + 0] = (float)(dArray[n2 + 0] * dArray2[n3 + 0] + dArray[n2 + 4] * dArray2[n3 + 1] + dArray[n2 + 8] * dArray2[n3 + 2] + dArray[n2 + 12] * dArray2[n3 + 3]);
        fArray[n + 1] = (float)(dArray[n2 + 1] * dArray2[n3 + 0] + dArray[n2 + 5] * dArray2[n3 + 1] + dArray[n2 + 9] * dArray2[n3 + 2] + dArray[n2 + 13] * dArray2[n3 + 3]);
        fArray[n + 2] = (float)(dArray[n2 + 2] * dArray2[n3 + 0] + dArray[n2 + 6] * dArray2[n3 + 1] + dArray[n2 + 10] * dArray2[n3 + 2] + dArray[n2 + 14] * dArray2[n3 + 3]);
        fArray[n + 3] = (float)(dArray[n2 + 3] * dArray2[n3 + 0] + dArray[n2 + 7] * dArray2[n3 + 1] + dArray[n2 + 11] * dArray2[n3 + 2] + dArray[n2 + 15] * dArray2[n3 + 3]);
    }

    public static void multiplyMV(float[] fArray, int n, double[] dArray, int n2, float[] fArray2, int n3) {
        fArray[n + 0] = (float)(dArray[0] * (double)fArray2[0] + dArray[4] * (double)fArray2[1] + dArray[8] * (double)fArray2[2] + dArray[12] * (double)fArray2[3]);
        fArray[n + 1] = (float)(dArray[1] * (double)fArray2[0] + dArray[5] * (double)fArray2[1] + dArray[9] * (double)fArray2[2] + dArray[13] * (double)fArray2[3]);
        fArray[n + 2] = (float)(dArray[2] * (double)fArray2[0] + dArray[6] * (double)fArray2[1] + dArray[10] * (double)fArray2[2] + dArray[14] * (double)fArray2[3]);
        fArray[n + 3] = (float)(dArray[3] * (double)fArray2[0] + dArray[7] * (double)fArray2[1] + dArray[11] * (double)fArray2[2] + dArray[15] * (double)fArray2[3]);
    }

    public static void multiplyMV(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        dArray[n + 0] = dArray2[0] * dArray3[0] + dArray2[4] * dArray3[1] + dArray2[8] * dArray3[2] + dArray2[12] * dArray3[3];
        dArray[n + 1] = dArray2[1] * dArray3[0] + dArray2[5] * dArray3[1] + dArray2[9] * dArray3[2] + dArray2[13] * dArray3[3];
        dArray[n + 2] = dArray2[2] * dArray3[0] + dArray2[6] * dArray3[1] + dArray2[10] * dArray3[2] + dArray2[14] * dArray3[3];
        dArray[n + 3] = dArray2[3] * dArray3[0] + dArray2[7] * dArray3[1] + dArray2[11] * dArray3[2] + dArray2[15] * dArray3[3];
    }

    public static void transposeM(float[] fArray, int n, float[] fArray2, int n2) {
        for (int i = 0; i < 4; ++i) {
            int n3 = i * 4 + n2;
            fArray[i + n] = fArray2[n3];
            fArray[i + 4 + n] = fArray2[n3 + 1];
            fArray[i + 8 + n] = fArray2[n3 + 2];
            fArray[i + 12 + n] = fArray2[n3 + 3];
        }
    }

    public static void transposeM(double[] dArray, int n, double[] dArray2, int n2) {
        for (int i = 0; i < 4; ++i) {
            int n3 = i * 4 + n2;
            dArray[i + n] = dArray2[n3];
            dArray[i + 4 + n] = dArray2[n3 + 1];
            dArray[i + 8 + n] = dArray2[n3 + 2];
            dArray[i + 12 + n] = dArray2[n3 + 3];
        }
    }

    public static boolean invertM(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray2[n2 + 0];
        float f2 = fArray2[n2 + 1];
        float f3 = fArray2[n2 + 2];
        float f4 = fArray2[n2 + 3];
        float f5 = fArray2[n2 + 4];
        float f6 = fArray2[n2 + 5];
        float f7 = fArray2[n2 + 6];
        float f8 = fArray2[n2 + 7];
        float f9 = fArray2[n2 + 8];
        float f10 = fArray2[n2 + 9];
        float f11 = fArray2[n2 + 10];
        float f12 = fArray2[n2 + 11];
        float f13 = fArray2[n2 + 12];
        float f14 = fArray2[n2 + 13];
        float f15 = fArray2[n2 + 14];
        float f16 = fArray2[n2 + 15];
        float f17 = f11 * f16;
        float f18 = f15 * f12;
        float f19 = f7 * f16;
        float f20 = f15 * f8;
        float f21 = f7 * f12;
        float f22 = f11 * f8;
        float f23 = f3 * f16;
        float f24 = f15 * f4;
        float f25 = f3 * f12;
        float f26 = f11 * f4;
        float f27 = f3 * f8;
        float f28 = f7 * f4;
        float f29 = f17 * f6 + f20 * f10 + f21 * f14 - (f18 * f6 + f19 * f10 + f22 * f14);
        float f30 = f18 * f2 + f23 * f10 + f26 * f14 - (f17 * f2 + f24 * f10 + f25 * f14);
        float f31 = f19 * f2 + f24 * f6 + f27 * f14 - (f20 * f2 + f23 * f6 + f28 * f14);
        float f32 = f22 * f2 + f25 * f6 + f28 * f10 - (f21 * f2 + f26 * f6 + f27 * f10);
        float f33 = f18 * f5 + f19 * f9 + f22 * f13 - (f17 * f5 + f20 * f9 + f21 * f13);
        float f34 = f17 * f + f24 * f9 + f25 * f13 - (f18 * f + f23 * f9 + f26 * f13);
        float f35 = f20 * f + f23 * f5 + f28 * f13 - (f19 * f + f24 * f5 + f27 * f13);
        float f36 = f21 * f + f26 * f5 + f27 * f9 - (f22 * f + f25 * f5 + f28 * f9);
        float f37 = f9 * f14;
        float f38 = f13 * f10;
        float f39 = f5 * f14;
        float f40 = f13 * f6;
        float f41 = f5 * f10;
        float f42 = f9 * f6;
        float f43 = f * f14;
        float f44 = f13 * f2;
        float f45 = f * f10;
        float f46 = f9 * f2;
        float f47 = f * f6;
        float f48 = f5 * f2;
        float f49 = f37 * f8 + f40 * f12 + f41 * f16 - (f38 * f8 + f39 * f12 + f42 * f16);
        float f50 = f38 * f4 + f43 * f12 + f46 * f16 - (f37 * f4 + f44 * f12 + f45 * f16);
        float f51 = f39 * f4 + f44 * f8 + f47 * f16 - (f40 * f4 + f43 * f8 + f48 * f16);
        float f52 = f42 * f4 + f45 * f8 + f48 * f12 - (f41 * f4 + f46 * f8 + f47 * f12);
        float f53 = f39 * f11 + f42 * f15 + f38 * f7 - (f41 * f15 + f37 * f7 + f40 * f11);
        float f54 = f45 * f15 + f37 * f3 + f44 * f11 - (f43 * f11 + f46 * f15 + f38 * f3);
        float f55 = f43 * f7 + f48 * f15 + f40 * f3 - (f47 * f15 + f39 * f3 + f44 * f7);
        float f56 = f47 * f11 + f41 * f3 + f46 * f7 - (f45 * f7 + f48 * f11 + f42 * f3);
        float f57 = f * f29 + f5 * f30 + f9 * f31 + f13 * f32;
        if (f57 == 0.0f) {
            return false;
        }
        float f58 = 1.0f / f57;
        fArray[n] = f29 * f58;
        fArray[1 + n] = f30 * f58;
        fArray[2 + n] = f31 * f58;
        fArray[3 + n] = f32 * f58;
        fArray[4 + n] = f33 * f58;
        fArray[5 + n] = f34 * f58;
        fArray[6 + n] = f35 * f58;
        fArray[7 + n] = f36 * f58;
        fArray[8 + n] = f49 * f58;
        fArray[9 + n] = f50 * f58;
        fArray[10 + n] = f51 * f58;
        fArray[11 + n] = f52 * f58;
        fArray[12 + n] = f53 * f58;
        fArray[13 + n] = f54 * f58;
        fArray[14 + n] = f55 * f58;
        fArray[15 + n] = f56 * f58;
        return true;
    }

    public static boolean invertM(double[] dArray, int n, double[] dArray2, int n2) {
        double d = dArray2[n2 + 0];
        double d2 = dArray2[n2 + 1];
        double d3 = dArray2[n2 + 2];
        double d4 = dArray2[n2 + 3];
        double d5 = dArray2[n2 + 4];
        double d6 = dArray2[n2 + 5];
        double d7 = dArray2[n2 + 6];
        double d8 = dArray2[n2 + 7];
        double d9 = dArray2[n2 + 8];
        double d10 = dArray2[n2 + 9];
        double d11 = dArray2[n2 + 10];
        double d12 = dArray2[n2 + 11];
        double d13 = dArray2[n2 + 12];
        double d14 = dArray2[n2 + 13];
        double d15 = dArray2[n2 + 14];
        double d16 = dArray2[n2 + 15];
        double d17 = d11 * d16;
        double d18 = d15 * d12;
        double d19 = d7 * d16;
        double d20 = d15 * d8;
        double d21 = d7 * d12;
        double d22 = d11 * d8;
        double d23 = d3 * d16;
        double d24 = d15 * d4;
        double d25 = d3 * d12;
        double d26 = d11 * d4;
        double d27 = d3 * d8;
        double d28 = d7 * d4;
        double d29 = d17 * d6 + d20 * d10 + d21 * d14 - (d18 * d6 + d19 * d10 + d22 * d14);
        double d30 = d18 * d2 + d23 * d10 + d26 * d14 - (d17 * d2 + d24 * d10 + d25 * d14);
        double d31 = d19 * d2 + d24 * d6 + d27 * d14 - (d20 * d2 + d23 * d6 + d28 * d14);
        double d32 = d22 * d2 + d25 * d6 + d28 * d10 - (d21 * d2 + d26 * d6 + d27 * d10);
        double d33 = d18 * d5 + d19 * d9 + d22 * d13 - (d17 * d5 + d20 * d9 + d21 * d13);
        double d34 = d17 * d + d24 * d9 + d25 * d13 - (d18 * d + d23 * d9 + d26 * d13);
        double d35 = d20 * d + d23 * d5 + d28 * d13 - (d19 * d + d24 * d5 + d27 * d13);
        double d36 = d21 * d + d26 * d5 + d27 * d9 - (d22 * d + d25 * d5 + d28 * d9);
        double d37 = d9 * d14;
        double d38 = d13 * d10;
        double d39 = d5 * d14;
        double d40 = d13 * d6;
        double d41 = d5 * d10;
        double d42 = d9 * d6;
        double d43 = d * d14;
        double d44 = d13 * d2;
        double d45 = d * d10;
        double d46 = d9 * d2;
        double d47 = d * d6;
        double d48 = d5 * d2;
        double d49 = d37 * d8 + d40 * d12 + d41 * d16 - (d38 * d8 + d39 * d12 + d42 * d16);
        double d50 = d38 * d4 + d43 * d12 + d46 * d16 - (d37 * d4 + d44 * d12 + d45 * d16);
        double d51 = d39 * d4 + d44 * d8 + d47 * d16 - (d40 * d4 + d43 * d8 + d48 * d16);
        double d52 = d42 * d4 + d45 * d8 + d48 * d12 - (d41 * d4 + d46 * d8 + d47 * d12);
        double d53 = d39 * d11 + d42 * d15 + d38 * d7 - (d41 * d15 + d37 * d7 + d40 * d11);
        double d54 = d45 * d15 + d37 * d3 + d44 * d11 - (d43 * d11 + d46 * d15 + d38 * d3);
        double d55 = d43 * d7 + d48 * d15 + d40 * d3 - (d47 * d15 + d39 * d3 + d44 * d7);
        double d56 = d47 * d11 + d41 * d3 + d46 * d7 - (d45 * d7 + d48 * d11 + d42 * d3);
        double d57 = d * d29 + d5 * d30 + d9 * d31 + d13 * d32;
        if (d57 == 0.0) {
            return false;
        }
        double d58 = 1.0 / d57;
        dArray[n] = d29 * d58;
        dArray[1 + n] = d30 * d58;
        dArray[2 + n] = d31 * d58;
        dArray[3 + n] = d32 * d58;
        dArray[4 + n] = d33 * d58;
        dArray[5 + n] = d34 * d58;
        dArray[6 + n] = d35 * d58;
        dArray[7 + n] = d36 * d58;
        dArray[8 + n] = d49 * d58;
        dArray[9 + n] = d50 * d58;
        dArray[10 + n] = d51 * d58;
        dArray[11 + n] = d52 * d58;
        dArray[12 + n] = d53 * d58;
        dArray[13 + n] = d54 * d58;
        dArray[14 + n] = d55 * d58;
        dArray[15 + n] = d56 * d58;
        return true;
    }

    public static void orthoM(float[] fArray, int n, float f, float f2, float f3, float f4, float f5, float f6) {
        if (f == f2) {
            throw new IllegalArgumentException("left == right");
        }
        if (f3 == f4) {
            throw new IllegalArgumentException("bottom == top");
        }
        if (f5 == f6) {
            throw new IllegalArgumentException("near == far");
        }
        float f7 = 1.0f / (f2 - f);
        float f8 = 1.0f / (f4 - f3);
        float f9 = 1.0f / (f6 - f5);
        float f10 = 2.0f * f7;
        float f11 = 2.0f * f8;
        float f12 = -2.0f * f9;
        float f13 = -(f2 + f) * f7;
        float f14 = -(f4 + f3) * f8;
        float f15 = -(f6 + f5) * f9;
        fArray[n + 0] = f10;
        fArray[n + 5] = f11;
        fArray[n + 10] = f12;
        fArray[n + 12] = f13;
        fArray[n + 13] = f14;
        fArray[n + 14] = f15;
        fArray[n + 15] = 1.0f;
        fArray[n + 1] = 0.0f;
        fArray[n + 2] = 0.0f;
        fArray[n + 3] = 0.0f;
        fArray[n + 4] = 0.0f;
        fArray[n + 6] = 0.0f;
        fArray[n + 7] = 0.0f;
        fArray[n + 8] = 0.0f;
        fArray[n + 9] = 0.0f;
        fArray[n + 11] = 0.0f;
    }

    public static void frustumM(float[] fArray, int n, float f, float f2, float f3, float f4, float f5, float f6) {
        if (f == f2) {
            throw new IllegalArgumentException("left == right");
        }
        if (f4 == f3) {
            throw new IllegalArgumentException("top == bottom");
        }
        if (f5 == f6) {
            throw new IllegalArgumentException("near == far");
        }
        if (f5 <= 0.0f) {
            throw new IllegalArgumentException("near <= 0.0f");
        }
        if (f6 <= 0.0f) {
            throw new IllegalArgumentException("far <= 0.0f");
        }
        float f7 = 1.0f / (f2 - f);
        float f8 = 1.0f / (f4 - f3);
        float f9 = 1.0f / (f5 - f6);
        float f10 = 2.0f * (f5 * f7);
        float f11 = 2.0f * (f5 * f8);
        float f12 = (f2 + f) * f7;
        float f13 = (f4 + f3) * f8;
        float f14 = (f6 + f5) * f9;
        float f15 = 2.0f * (f6 * f5 * f9);
        fArray[n + 0] = f10;
        fArray[n + 5] = f11;
        fArray[n + 8] = f12;
        fArray[n + 9] = f13;
        fArray[n + 10] = f14;
        fArray[n + 14] = f15;
        fArray[n + 11] = -1.0f;
        fArray[n + 1] = 0.0f;
        fArray[n + 2] = 0.0f;
        fArray[n + 3] = 0.0f;
        fArray[n + 4] = 0.0f;
        fArray[n + 6] = 0.0f;
        fArray[n + 7] = 0.0f;
        fArray[n + 12] = 0.0f;
        fArray[n + 13] = 0.0f;
        fArray[n + 15] = 0.0f;
    }

    public static void perspectiveM(float[] fArray, int n, float f, float f2, float f3, float f4) {
        float f5 = 1.0f / (float)Math.tan((double)f * (Math.PI / 360));
        float f6 = 1.0f / (f3 - f4);
        fArray[n + 0] = f5 / f2;
        fArray[n + 1] = 0.0f;
        fArray[n + 2] = 0.0f;
        fArray[n + 3] = 0.0f;
        fArray[n + 4] = 0.0f;
        fArray[n + 5] = f5;
        fArray[n + 6] = 0.0f;
        fArray[n + 7] = 0.0f;
        fArray[n + 8] = 0.0f;
        fArray[n + 9] = 0.0f;
        fArray[n + 10] = (f4 + f3) * f6;
        fArray[n + 11] = -1.0f;
        fArray[n + 12] = 0.0f;
        fArray[n + 13] = 0.0f;
        fArray[n + 14] = 2.0f * f4 * f3 * f6;
        fArray[n + 15] = 0.0f;
    }

    public static float length(float f, float f2, float f3) {
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public static double length(double d, double d2, double d3) {
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public static void setIdentityM(float[] fArray, int n) {
        int n2;
        for (n2 = 0; n2 < 16; ++n2) {
            fArray[n + n2] = 0.0f;
        }
        for (n2 = 0; n2 < 16; n2 += 5) {
            fArray[n + n2] = 1.0f;
        }
    }

    public static void setIdentityM(double[] dArray, int n) {
        int n2;
        for (n2 = 0; n2 < 16; ++n2) {
            dArray[n + n2] = 0.0;
        }
        for (n2 = 0; n2 < 16; n2 += 5) {
            dArray[n + n2] = 1.0;
        }
    }

    public static void scaleM(float[] fArray, int n, float[] fArray2, int n2, float f, float f2, float f3) {
        for (int i = 0; i < 4; ++i) {
            int n3 = n + i;
            int n4 = n2 + i;
            fArray[n3] = fArray2[n4] * f;
            fArray[4 + n3] = fArray2[4 + n4] * f2;
            fArray[8 + n3] = fArray2[8 + n4] * f3;
            fArray[12 + n3] = fArray2[12 + n4];
        }
    }

    public static void scaleM(double[] dArray, int n, double d, double d2, double d3) {
        for (int i = 0; i < 4; ++i) {
            int n2;
            int n3 = n2 = n + i;
            dArray[n3] = dArray[n3] * d;
            int n4 = 4 + n2;
            dArray[n4] = dArray[n4] * d2;
            int n5 = 8 + n2;
            dArray[n5] = dArray[n5] * d3;
        }
    }

    public static void scaleM(float[] fArray, int n, float f, float f2, float f3) {
        for (int i = 0; i < 4; ++i) {
            int n2;
            int n3 = n2 = n + i;
            fArray[n3] = fArray[n3] * f;
            int n4 = 4 + n2;
            fArray[n4] = fArray[n4] * f2;
            int n5 = 8 + n2;
            fArray[n5] = fArray[n5] * f3;
        }
    }

    public static void scaleM(double[] dArray, int n, float f, float f2, float f3) {
        for (int i = 0; i < 4; ++i) {
            int n2;
            int n3 = n2 = n + i;
            dArray[n3] = dArray[n3] * (double)f;
            int n4 = 4 + n2;
            dArray[n4] = dArray[n4] * (double)f2;
            int n5 = 8 + n2;
            dArray[n5] = dArray[n5] * (double)f3;
        }
    }

    public static void translateM(float[] fArray, int n, float[] fArray2, int n2, float f, float f2, float f3) {
        int n3;
        for (n3 = 0; n3 < 12; ++n3) {
            fArray[n + n3] = fArray2[n2 + n3];
        }
        for (n3 = 0; n3 < 4; ++n3) {
            int n4 = n + n3;
            int n5 = n2 + n3;
            fArray[12 + n4] = fArray2[n5] * f + fArray2[4 + n5] * f2 + fArray2[8 + n5] * f3 + fArray2[12 + n5];
        }
    }

    public static void translateM(double[] dArray, int n, double[] dArray2, int n2, double d, double d2, double d3) {
        int n3;
        for (n3 = 0; n3 < 12; ++n3) {
            dArray[n + n3] = dArray2[n2 + n3];
        }
        for (n3 = 0; n3 < 4; ++n3) {
            int n4 = n + n3;
            int n5 = n2 + n3;
            dArray[12 + n4] = dArray2[n5] * d + dArray2[4 + n5] * d2 + dArray2[8 + n5] * d3 + dArray2[12 + n5];
        }
    }

    public static void translateM(float[] fArray, int n, float f, float f2, float f3) {
        for (int i = 0; i < 4; ++i) {
            int n2 = n + i;
            int n3 = 12 + n2;
            fArray[n3] = fArray[n3] + (fArray[n2] * f + fArray[4 + n2] * f2 + fArray[8 + n2] * f3);
        }
    }

    public static void translateM(double[] dArray, int n, double d, double d2, double d3) {
        for (int i = 0; i < 4; ++i) {
            int n2 = n + i;
            int n3 = 12 + n2;
            dArray[n3] = dArray[n3] + (dArray[n2] * d + dArray[4 + n2] * d2 + dArray[8 + n2] * d3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateM(float[] fArray, int n, float[] fArray2, int n2, float f, float f2, float f3, float f4) {
        float[] fArray3 = sTemp;
        synchronized (sTemp) {
            Matrix.setRotateM(sTemp, 0, f, f2, f3, f4);
            Matrix.multiplyMM(fArray, n, fArray2, n2, sTemp, 0);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateM(double[] dArray, int n, double[] dArray2, int n2, double d, double d2, double d3, double d4) {
        double[] dArray3 = sTempD;
        synchronized (sTempD) {
            Matrix.setRotateM(sTempD, 0, d, d2, d3, d4);
            Matrix.multiplyMM(dArray, n, dArray2, n2, sTempD, 0);
            // ** MonitorExit[var12_8] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateM(float[] fArray, int n, float f, float f2, float f3, float f4) {
        float[] fArray2 = sTemp;
        synchronized (sTemp) {
            Matrix.setRotateM(sTemp, 0, f, f2, f3, f4);
            Matrix.multiplyMM(sTemp, 16, fArray, n, sTemp, 0);
            System.arraycopy(sTemp, 16, fArray, n, 16);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateM(double[] dArray, int n, double d, double d2, double d3, double d4) {
        double[] dArray2 = sTempD;
        synchronized (sTempD) {
            Matrix.setRotateM(sTempD, 0, d, d2, d3, d4);
            Matrix.multiplyMM(sTempD, 16, dArray, n, sTempD, 0);
            System.arraycopy(sTempD, 16, dArray, n, 16);
            // ** MonitorExit[var10_6] (shouldn't be in output)
            return;
        }
    }

    public static void setRotateM(float[] fArray, int n, float f, float f2, float f3, float f4) {
        fArray[n + 3] = 0.0f;
        fArray[n + 7] = 0.0f;
        fArray[n + 11] = 0.0f;
        fArray[n + 12] = 0.0f;
        fArray[n + 13] = 0.0f;
        fArray[n + 14] = 0.0f;
        fArray[n + 15] = 1.0f;
        float f5 = (float)Math.sin(f *= (float)Math.PI / 180);
        float f6 = (float)Math.cos(f);
        if (1.0f == f2 && 0.0f == f3 && 0.0f == f4) {
            fArray[n + 5] = f6;
            fArray[n + 10] = f6;
            fArray[n + 6] = f5;
            fArray[n + 9] = -f5;
            fArray[n + 1] = 0.0f;
            fArray[n + 2] = 0.0f;
            fArray[n + 4] = 0.0f;
            fArray[n + 8] = 0.0f;
            fArray[n + 0] = 1.0f;
        } else if (0.0f == f2 && 1.0f == f3 && 0.0f == f4) {
            fArray[n + 0] = f6;
            fArray[n + 10] = f6;
            fArray[n + 8] = f5;
            fArray[n + 2] = -f5;
            fArray[n + 1] = 0.0f;
            fArray[n + 4] = 0.0f;
            fArray[n + 6] = 0.0f;
            fArray[n + 9] = 0.0f;
            fArray[n + 5] = 1.0f;
        } else if (0.0f == f2 && 0.0f == f3 && 1.0f == f4) {
            fArray[n + 0] = f6;
            fArray[n + 5] = f6;
            fArray[n + 1] = f5;
            fArray[n + 4] = -f5;
            fArray[n + 2] = 0.0f;
            fArray[n + 6] = 0.0f;
            fArray[n + 8] = 0.0f;
            fArray[n + 9] = 0.0f;
            fArray[n + 10] = 1.0f;
        } else {
            float f7;
            float f8 = Matrix.length(f2, f3, f4);
            if (1.0f != f8) {
                f7 = 1.0f / f8;
                f2 *= f7;
                f3 *= f7;
                f4 *= f7;
            }
            f7 = 1.0f - f6;
            float f9 = f2 * f3;
            float f10 = f3 * f4;
            float f11 = f4 * f2;
            float f12 = f2 * f5;
            float f13 = f3 * f5;
            float f14 = f4 * f5;
            fArray[n + 0] = f2 * f2 * f7 + f6;
            fArray[n + 4] = f9 * f7 - f14;
            fArray[n + 8] = f11 * f7 + f13;
            fArray[n + 1] = f9 * f7 + f14;
            fArray[n + 5] = f3 * f3 * f7 + f6;
            fArray[n + 9] = f10 * f7 - f12;
            fArray[n + 2] = f11 * f7 - f13;
            fArray[n + 6] = f10 * f7 + f12;
            fArray[n + 10] = f4 * f4 * f7 + f6;
        }
    }

    public static void setRotateM(double[] dArray, int n, double d, double d2, double d3, double d4) {
        dArray[n + 3] = 0.0;
        dArray[n + 7] = 0.0;
        dArray[n + 11] = 0.0;
        dArray[n + 12] = 0.0;
        dArray[n + 13] = 0.0;
        dArray[n + 14] = 0.0;
        dArray[n + 15] = 1.0;
        double d5 = (float)Math.sin(d *= Math.PI / 180);
        double d6 = (float)Math.cos(d);
        if (1.0 == d2 && 0.0 == d3 && 0.0 == d4) {
            dArray[n + 5] = d6;
            dArray[n + 10] = d6;
            dArray[n + 6] = d5;
            dArray[n + 9] = -d5;
            dArray[n + 1] = 0.0;
            dArray[n + 2] = 0.0;
            dArray[n + 4] = 0.0;
            dArray[n + 8] = 0.0;
            dArray[n + 0] = 1.0;
        } else if (0.0 == d2 && 1.0 == d3 && 0.0 == d4) {
            dArray[n + 0] = d6;
            dArray[n + 10] = d6;
            dArray[n + 8] = d5;
            dArray[n + 2] = -d5;
            dArray[n + 1] = 0.0;
            dArray[n + 4] = 0.0;
            dArray[n + 6] = 0.0;
            dArray[n + 9] = 0.0;
            dArray[n + 5] = 1.0;
        } else if (0.0 == d2 && 0.0 == d3 && 1.0 == d4) {
            dArray[n + 0] = d6;
            dArray[n + 5] = d6;
            dArray[n + 1] = d5;
            dArray[n + 4] = -d5;
            dArray[n + 2] = 0.0;
            dArray[n + 6] = 0.0;
            dArray[n + 8] = 0.0;
            dArray[n + 9] = 0.0;
            dArray[n + 10] = 1.0;
        } else {
            double d7;
            double d8 = Matrix.length(d2, d3, d4);
            if (1.0 != d8) {
                d7 = 1.0 / d8;
                d2 *= d7;
                d3 *= d7;
                d4 *= d7;
            }
            d7 = 1.0 - d6;
            double d9 = d2 * d3;
            double d10 = d3 * d4;
            double d11 = d4 * d2;
            double d12 = d2 * d5;
            double d13 = d3 * d5;
            double d14 = d4 * d5;
            dArray[n + 0] = d2 * d2 * d7 + d6;
            dArray[n + 4] = d9 * d7 - d14;
            dArray[n + 8] = d11 * d7 + d13;
            dArray[n + 1] = d9 * d7 + d14;
            dArray[n + 5] = d3 * d3 * d7 + d6;
            dArray[n + 9] = d10 * d7 - d12;
            dArray[n + 2] = d11 * d7 - d13;
            dArray[n + 6] = d10 * d7 + d12;
            dArray[n + 10] = d4 * d4 * d7 + d6;
        }
    }

    public static void setRotateEulerM(float[] fArray, int n, float f, float f2, float f3) {
        float f4 = (float)Math.cos(f *= (float)Math.PI / 180);
        float f5 = (float)Math.sin(f);
        float f6 = (float)Math.cos(f2 *= (float)Math.PI / 180);
        float f7 = (float)Math.sin(f2);
        float f8 = (float)Math.cos(f3 *= (float)Math.PI / 180);
        float f9 = (float)Math.sin(f3);
        float f10 = f4 * f7;
        float f11 = f5 * f7;
        fArray[n + 0] = f6 * f8;
        fArray[n + 1] = -f6 * f9;
        fArray[n + 2] = f7;
        fArray[n + 3] = 0.0f;
        fArray[n + 4] = f10 * f8 + f4 * f9;
        fArray[n + 5] = -f10 * f9 + f4 * f8;
        fArray[n + 6] = -f5 * f6;
        fArray[n + 7] = 0.0f;
        fArray[n + 8] = -f11 * f8 + f5 * f9;
        fArray[n + 9] = f11 * f9 + f5 * f8;
        fArray[n + 10] = f4 * f6;
        fArray[n + 11] = 0.0f;
        fArray[n + 12] = 0.0f;
        fArray[n + 13] = 0.0f;
        fArray[n + 14] = 0.0f;
        fArray[n + 15] = 1.0f;
    }

    public static void setLookAtM(float[] fArray, int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f4 - f;
        float f11 = f5 - f2;
        float f12 = f6 - f3;
        float f13 = 1.0f / Matrix.length(f10, f11, f12);
        float f14 = (f11 *= f13) * f9 - (f12 *= f13) * f8;
        float f15 = f12 * f7 - (f10 *= f13) * f9;
        float f16 = f10 * f8 - f11 * f7;
        float f17 = 1.0f / Matrix.length(f14, f15, f16);
        float f18 = (f15 *= f17) * f12 - (f16 *= f17) * f11;
        float f19 = f16 * f10 - (f14 *= f17) * f12;
        float f20 = f14 * f11 - f15 * f10;
        fArray[n + 0] = f14;
        fArray[n + 1] = f18;
        fArray[n + 2] = -f10;
        fArray[n + 3] = 0.0f;
        fArray[n + 4] = f15;
        fArray[n + 5] = f19;
        fArray[n + 6] = -f11;
        fArray[n + 7] = 0.0f;
        fArray[n + 8] = f16;
        fArray[n + 9] = f20;
        fArray[n + 10] = -f12;
        fArray[n + 11] = 0.0f;
        fArray[n + 12] = 0.0f;
        fArray[n + 13] = 0.0f;
        fArray[n + 14] = 0.0f;
        fArray[n + 15] = 1.0f;
        Matrix.translateM(fArray, n, -f, -f2, -f3);
    }

    public static void dump(float[] fArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                System.out.print(fArray[j * 4 + i] + (j == 3 ? "" : ", "));
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void copy(float[] fArray, float[] fArray2) {
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
    }

    public static void copy(double[] dArray, double[] dArray2) {
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
    }

    public static float[] changeOrientation(float[] fArray) {
        float[] fArray2 = new float[]{fArray[0], fArray[4], fArray[8], fArray[12], fArray[1], fArray[5], fArray[9], fArray[13], fArray[2], fArray[6], fArray[10], fArray[14], fArray[3], fArray[7], fArray[11], fArray[15]};
        return fArray2;
    }

    public static double[] changeOrientation(double[] dArray) {
        double[] dArray2 = new double[]{dArray[0], dArray[4], dArray[8], dArray[12], dArray[1], dArray[5], dArray[9], dArray[13], dArray[2], dArray[6], dArray[10], dArray[14], dArray[3], dArray[7], dArray[11], dArray[15]};
        return dArray2;
    }

    public static void dump(String string, double[] dArray) {
        System.out.println(string);
        Matrix.dump(dArray);
    }

    public static void dump(double[] dArray) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                System.out.print(dArray[j * 4 + i] + (j == 3 ? "" : ", "));
            }
            System.out.println();
        }
    }

    public static void dumpIfNotId(double[] dArray) {
        if (!Arrays.equals(dArray, Matrix.identity())) {
            Matrix.dump(dArray);
        }
    }

    public static double[] identity() {
        double[] dArray = new double[16];
        Matrix.setIdentityM(dArray, 0);
        return dArray;
    }

    public static float[] identityF() {
        float[] fArray = new float[16];
        Matrix.setIdentityM(fArray, 0);
        return fArray;
    }

    public static boolean isIdentity(double[] dArray) {
        double[] dArray2 = Matrix.identity();
        return Arrays.equals(dArray2, dArray);
    }
}

