package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import nl.sascom.backplanepublic.common.Response;

public class BuildingStoreyLevelQuery implements Comparable<BuildingStoreyLevelQuery>, CompareQuery {
	private Operator operator;
	private JsonNode value;

	public BuildingStoreyLevelQuery() {
	}
	
	public BuildingStoreyLevelQuery(Operator operator, JsonNode value) {
		this.operator = operator;
		this.value = value;
	}
	
	public ObjectNode toJson() {
		ObjectNode objectNode = Response.createObject();
		objectNode.set("operator", operator.toJson());
		if (value != null) {
			objectNode.set("value", value);
		}
		return objectNode;
	}
	
	public Operator getOperator() {
		return operator;
	}
	
	public JsonNode getValue() {
		return value;
	}

	@Override
	public int compareTo(BuildingStoreyLevelQuery o) {
		return this.getName().compareTo(o.getName());
	}

	public static BuildingStoreyLevelQuery of(JsonNode quantityNode) {
		return new BuildingStoreyLevelQuery(quantityNode.hasNonNull("operator") ? Operator.bySymbol(quantityNode.get("operator").asText()) : Operator.EXISTS, quantityNode.get("value"));
	}

	@Override
	@JsonIgnore
	public String getName() {
		return "buildingStorey.level";
	}
}
