/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.google.common.io.ByteSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import nl.bimbase.bimworks.storage.DurabilityScope;
import nl.bimbase.bimworks.storage.PutArgs;
import nl.bimbase.bimworks.storage.UnmetDurabilityScopeStorageBackendException;
import nl.bimbase.bimworks.storage.WriteSlotInterface;
import nl.sascom.backplanepublic.common.LocalStreamDescriptor;
import nl.sascom.backplanepublic.common.Stream;
import nl.sascom.backplanepublic.common.StreamDescriptor;
import nl.sascom.backplanepublic.common.StreamManager;
import nl.sascom.backplanepublic.common.StreamMetaData;
import nl.sascom.backplanepublic.common.StreamReadingByteSource;
import nl.sascom.backplanepublic.common.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteableStream
extends OutputStream
implements Stream,
StreamSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteableStream.class);
    private String key;
    private StreamMetaData streamMetaData;
    private RandomAccessFile randomAccessFile;
    private long writePosition = 0L;
    private volatile boolean writingDone;
    private final Set<CountDownLatch> latches = new HashSet<CountDownLatch>();
    private WriteSlotInterface writeSlot;

    public WriteableStream(StreamManager streamManager, String string, StreamMetaData streamMetaData) {
        this.key = string;
        this.streamMetaData = streamMetaData;
        try {
            this.writeSlot = streamManager.getStorageManager().createWriteSlot(Paths.get(this.getKey(), new String[0]), false, PutArgs.of(DurabilityScope.JVM));
            this.randomAccessFile = new RandomAccessFile(this.writeSlot.getPath().toFile(), "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (UnmetDurabilityScopeStorageBackendException unmetDurabilityScopeStorageBackendException) {
            unmetDurabilityScopeStorageBackendException.printStackTrace();
        }
    }

    @Override
    public ByteSource getByteSource() {
        return new StreamReadingByteSource(this);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public StreamMetaData getStreamMetaData() {
        return this.streamMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        WriteableStream writeableStream = this;
        synchronized (writeableStream) {
            this.randomAccessFile.seek(this.writePosition);
            this.randomAccessFile.write(n);
            ++this.writePosition;
            Set<CountDownLatch> set = this.latches;
            synchronized (set) {
                for (CountDownLatch countDownLatch : this.latches) {
                    countDownLatch.countDown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        WriteableStream writeableStream = this;
        synchronized (writeableStream) {
            this.randomAccessFile.seek(this.writePosition);
            this.randomAccessFile.write(byArray, n, n2);
            this.writePosition += (long)n2;
            if (n2 > 0) {
                Set<CountDownLatch> set = this.latches;
                synchronized (set) {
                    for (CountDownLatch countDownLatch : this.latches) {
                        countDownLatch.countDown();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.writingDone = true;
        WriteableStream writeableStream = this;
        synchronized (writeableStream) {
            this.randomAccessFile.close();
            this.randomAccessFile = new RandomAccessFile(this.writeSlot.getPath().toFile(), "r");
        }
        try {
            this.writeSlot.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public StreamDescriptor getReadableStreamDescriptor() {
        return new LocalStreamDescriptor(this.key, null);
    }

    public long getBytesWritten() {
        return this.writePosition;
    }

    @Override
    public long getWritePosition() {
        return this.writePosition;
    }

    @Override
    public boolean writingIsDone() {
        return this.writingDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerWriteLatch(CountDownLatch countDownLatch, long l) {
        Set<CountDownLatch> set = this.latches;
        synchronized (set) {
            this.latches.add(countDownLatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterWriteLatch(CountDownLatch countDownLatch) {
        Set<CountDownLatch> set = this.latches;
        synchronized (set) {
            this.latches.remove(countDownLatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(long l, byte[] byArray, int n, int n2) throws IOException {
        WriteableStream writeableStream = this;
        synchronized (writeableStream) {
            this.randomAccessFile.seek(l);
            return this.randomAccessFile.read(byArray, n, n2);
        }
    }

    @Override
    public boolean isOpen() {
        return true;
    }
}

