/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import nl.sascom.backplane.appbase.common.CodeGenerator;
import nl.sascom.backplanepublic.common.listeners.Filter;
import nl.sascom.backplanepublic.common.listeners.FirstRegistrationAddedListener;
import nl.sascom.backplanepublic.common.listeners.InitialListenerTrigger;
import nl.sascom.backplanepublic.common.listeners.LastRegistrationRemovedListener;
import nl.sascom.backplanepublic.common.listeners.Listener;
import nl.sascom.backplanepublic.common.listeners.ListenerHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerManager {
    private ExecutorService executorService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ListenerManager.class);
    private final Map<Class<? extends Listener>, Set<ListenerHandle>> handles = new HashMap<Class<? extends Listener>, Set<ListenerHandle>>();
    private final Set<FirstRegistrationAddedListener> firstRegistrationAddedListeners = new HashSet<FirstRegistrationAddedListener>();
    private final Set<LastRegistrationRemovedListener> lastRegistrationRemovedListeners = new HashSet<LastRegistrationRemovedListener>();
    private final Map<Class<? extends Listener>, InitialListenerTrigger> initialTriggers = new HashMap<Class<? extends Listener>, InitialListenerTrigger>();
    private static final CodeGenerator codeGenerator = new CodeGenerator();

    public ListenerManager(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ListenerManager() {
        this.executorService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ListenerHandle register(Filter filter, Listener listener, boolean bl) {
        int n = this.handles.size();
        Class<? extends Listener> clazz = this.getRealInterface(listener.getClass());
        Set<ListenerHandle> set = this.handles.get(clazz);
        if (set == null) {
            set = new HashSet<ListenerHandle>();
            this.handles.put(clazz, set);
        }
        ListenerHandle listenerHandle = new ListenerHandle(this, filter, listener);
        Set<ListenerHandle> set2 = set;
        synchronized (set2) {
            set.add(listenerHandle);
        }
        if (n == 0) {
            this.triggerFirstRegistrationAddedListeners();
        }
        if (bl) {
            for (Map.Entry entry : this.initialTriggers.entrySet()) {
                ((InitialListenerTrigger)entry.getValue()).triggerForListener(listener);
            }
        }
        return listenerHandle;
    }

    public ListenerHandle register(Listener listener) {
        return this.register(null, listener, false);
    }

    public ListenerHandle register(Filter filter, Listener listener) {
        return this.register(filter, listener, false);
    }

    public ListenerHandle register(Listener listener, boolean bl) {
        return this.register(null, listener, bl);
    }

    private void triggerFirstRegistrationAddedListeners() {
        for (FirstRegistrationAddedListener firstRegistrationAddedListener : this.firstRegistrationAddedListeners) {
            firstRegistrationAddedListener.firstRegistrationAdded();
        }
    }

    private void triggerLastRegistrationRemovedListeners() {
        for (LastRegistrationRemovedListener lastRegistrationRemovedListener : this.lastRegistrationRemovedListeners) {
            lastRegistrationRemovedListener.lastRegistrationRemoved();
        }
    }

    public void addFirstRegistrationAddedListener(FirstRegistrationAddedListener firstRegistrationAddedListener) {
        this.firstRegistrationAddedListeners.add(firstRegistrationAddedListener);
    }

    public void addLastRegistrationRemovedListener(LastRegistrationRemovedListener lastRegistrationRemovedListener) {
        this.lastRegistrationRemovedListeners.add(lastRegistrationRemovedListener);
    }

    private Class<? extends Listener> getRealInterface(Class<? extends Listener> clazz) {
        Class<?>[] classArray;
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (!Listener.class.isAssignableFrom(clazz2)) continue;
            return clazz2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(ListenerHandle listenerHandle) {
        Class<? extends Listener> clazz = this.getRealInterface(listenerHandle.getListener().getClass());
        Set<ListenerHandle> set = this.handles.get(clazz);
        if (set != null) {
            Set<ListenerHandle> set2 = set;
            synchronized (set2) {
                set.remove(listenerHandle);
            }
        }
        if (this.handles.isEmpty()) {
            this.triggerLastRegistrationRemovedListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Listener> Collection<T> listeners(Class<T> clazz) {
        Set<ListenerHandle> set = this.handles.get(clazz);
        HashSet<Listener> hashSet = new HashSet<Listener>();
        if (set != null) {
            Set<ListenerHandle> set2 = set;
            synchronized (set2) {
                for (ListenerHandle listenerHandle : set) {
                    hashSet.add(listenerHandle.getListener());
                }
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<ListenerHandle> listenerIterator(Class<?> clazz) {
        Set<ListenerHandle> set = null;
        Object object = this;
        synchronized (object) {
            set = this.handles.get(clazz);
        }
        if (set != null) {
            object = set;
            synchronized (object) {
                return new HashSet<ListenerHandle>(set).iterator();
            }
        }
        return null;
    }

    public synchronized void close() {
        int n = 0;
        for (Class<? extends Listener> clazz : new HashSet<Class<? extends Listener>>(this.handles.keySet())) {
            Set<ListenerHandle> set = this.handles.get(clazz);
            for (ListenerHandle listenerHandle : new HashSet<ListenerHandle>(set)) {
                listenerHandle.close();
                ++n;
            }
        }
        LOGGER.info("Closed ListenerManager (" + n + ")");
    }

    public synchronized void dump() {
        for (Class<? extends Listener> clazz : this.handles.keySet()) {
            LOGGER.info(clazz.getName());
            Set<ListenerHandle> set = this.handles.get(clazz);
            for (ListenerHandle listenerHandle : set) {
                LOGGER.info("\t" + listenerHandle);
            }
        }
    }

    public <T extends Listener> T trigger(Class<T> clazz) {
        try {
            return codeGenerator.createImplementation(this, clazz);
        }
        catch (Exception exception) {
            LOGGER.error("", (Throwable)exception);
            return null;
        }
    }

    public <T extends Listener> T triggerAsync(Class<T> clazz) {
        try {
            return codeGenerator.createAsyncImplementation(this, clazz);
        }
        catch (Exception exception) {
            LOGGER.error("", (Throwable)exception);
            return null;
        }
    }

    public void dispatch(Runnable runnable) {
        if (this.executorService == null) {
            throw new RuntimeException("Async dispatch not supported");
        }
        this.executorService.submit(runnable);
    }

    public void registerInitialTrigger(Class<? extends Listener> clazz, InitialListenerTrigger<?> initialListenerTrigger) {
        this.initialTriggers.put(clazz, initialListenerTrigger);
    }
}

