/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.UUID;
import nl.sascom.backplanepublic.common.JsonUpdate;
import nl.sascom.backplanepublic.common.ResponseType;

public class DataPush
extends JsonUpdate {
    private JsonNode data;
    private String topicId;
    private boolean debug;

    public DataPush(UUID uUID, String string, JsonNode jsonNode) {
        super(uUID);
        this.topicId = string;
        this.data = jsonNode;
    }

    public DataPush(byte[] byArray) {
        super(byArray);
    }

    @Override
    public void setData(ObjectNode objectNode) {
        this.data = objectNode.get("data");
        this.topicId = objectNode.get("topicId").asText();
    }

    @Override
    public ResponseType getResponseType() {
        return ResponseType.DATA_PUSH;
    }

    @Override
    public ObjectNode toJson() {
        ObjectNode objectNode = super.toJson();
        objectNode.put("topicId", this.topicId);
        objectNode.set("data", this.data);
        if (this.debug) {
            objectNode.put("debug", true);
        }
        return objectNode;
    }

    public String toString() {
        return "DataPush";
    }

    public String getTopicId() {
        return this.topicId;
    }

    @Override
    public String getSubType() {
        return this.topicId;
    }

    public JsonNode getData() {
        return this.data;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

