/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.HashMap;
import java.util.Map;

public enum Operator {
    EQUALS("="),
    LESS_THAN("<"),
    GREATER_THAN(">"),
    LESS_THAN_OR_EQUALS("<="),
    GREATER_THAN_OR_EQUALS(">="),
    EXISTS(""),
    STARTS_WITH("startsWith"),
    BETWEEN_INCLUSIVE("between_inclusive"),
    LIKE("like");

    private String symbol;
    private static final Map<String, Operator> SYMBOL_MAP;

    static Operator bySymbol(String string) {
        return SYMBOL_MAP.get(string);
    }

    private Operator(String string2) {
        this.symbol = string2;
    }

    JsonNode toJson() {
        return TextNode.valueOf((String)this.symbol);
    }

    public boolean evaluate(double d, double d2) {
        switch (this) {
            case BETWEEN_INCLUSIVE: {
                break;
            }
            case EQUALS: {
                return d == d2;
            }
            case EXISTS: {
                break;
            }
            case GREATER_THAN: {
                return d > d2;
            }
            case GREATER_THAN_OR_EQUALS: {
                return d >= d2;
            }
            case LESS_THAN: {
                return d < d2;
            }
            case LESS_THAN_OR_EQUALS: {
                return d <= d2;
            }
            case LIKE: {
                break;
            }
            case STARTS_WITH: {
                break;
            }
        }
        return false;
    }

    public static Operator of(double d, double d2) {
        if (d == d2) {
            return EQUALS;
        }
        if (d > d2) {
            return GREATER_THAN;
        }
        if (d < d2) {
            return LESS_THAN;
        }
        return null;
    }

    @JsonValue
    public String getSymbol() {
        return this.symbol;
    }

    static {
        SYMBOL_MAP = new HashMap<String, Operator>();
        for (Operator operator : Operator.values()) {
            SYMBOL_MAP.put(operator.symbol, operator);
        }
    }
}

