/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.client;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ByteBufferHolder
implements Future<byte[]> {
    private ByteBuffer buffer;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private Exception exception;

    public ByteBufferHolder() {
    }

    public ByteBufferHolder(byte[] byArray) {
        this.buffer = ByteBuffer.wrap(byArray);
        this.countDownLatch.countDown();
    }

    public void init(int n) {
        this.buffer = ByteBuffer.allocate(n);
    }

    public void add(byte[] byArray) {
        this.buffer.put(byArray);
    }

    public void add(ByteBuffer byteBuffer) {
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(byteBuffer.capacity());
        }
        this.buffer.put(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.capacity());
    }

    public void close() {
        this.countDownLatch.countDown();
    }

    @Override
    public boolean cancel(boolean bl) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public byte[] get() throws InterruptedException, ExecutionException {
        this.countDownLatch.await();
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.buffer.array();
    }

    @Override
    public byte[] get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.countDownLatch.await(l, timeUnit)) {
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.buffer.array();
        }
        throw new TimeoutException("Timeout exceeded");
    }

    public void exception(Exception exception) {
        this.exception = exception;
        this.countDownLatch.countDown();
    }
}

