package nl.bimbase.bimworks.client;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import com.fasterxml.jackson.databind.node.ArrayNode;

import nl.sascom.backplanepublic.common.ClientTask;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;

public class AdminApi {

	private BimWorksClient bimWorksClient;

	public AdminApi(BimWorksClient bimWorksClient) {
		this.bimWorksClient = bimWorksClient;
	}
	
	public String createApiToken(UUID nodeUuid, String name, Set<String> allowedCorsDomains, Set<String> whiteListedIpAddresses, Set<ApiTokenCredential> credentials) throws ExecuteException, InterruptedException {
		Request request = bimWorksClient.createRequest();
		request.setTaskName("CreateApiToken");
		request.getObjectInput().put("node_uuid", nodeUuid.toString());
		request.getObjectInput().put("name", name);
		if (allowedCorsDomains != null) {
			request.put("only_cors_enabled_addresses", true);
			ArrayNode allowedCorsDomainsNode = Response.createArray();
			for (String domain : allowedCorsDomains) {
				allowedCorsDomainsNode.add(domain);
			}
			request.set("cors_enabled_domains", allowedCorsDomainsNode);
		}
		if (whiteListedIpAddresses != null) {
			request.put("only_white_listed_ip_addresses", true);
			ArrayNode whiteListedIpAddressesNode = Response.createArray();
			for (String ip : whiteListedIpAddresses) {
				whiteListedIpAddressesNode.add(ip);
			}
			request.set("white_listed_ip_addresses", whiteListedIpAddressesNode);
		}
		if (credentials != null) {
			ArrayNode credentialsNode = Response.createArray();
			for (ApiTokenCredential credential : credentials) {
				credentialsNode.add(credential.name());
			}
			request.set("credentials", credentialsNode);
		}
		request.setTimeOut(1, TimeUnit.MINUTES);
		ClientTask task = bimWorksClient.createAsyncTask(request);
		task.exec();
		return task.await(1, TimeUnit.MINUTES).getObjectOutput().get("token").asText();
	}
}
