/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplanepublic.common.processinginfo;

import java.util.ArrayList;
import java.util.List;
import nl.sascom.backplanepublic.common.processinginfo.ConsoleTable;
import nl.sascom.backplanepublic.common.processinginfo.Item;
import nl.sascom.backplanepublic.common.processinginfo.Label;
import nl.sascom.backplanepublic.common.processinginfo.Measurement;
import nl.sascom.backplanepublic.common.processinginfo.SubMeasurement;
import org.slf4j.Logger;

public class ProcessingInfo {
    private final List<Item> list = new ArrayList<Item>();
    private long start;
    private long lastStart;

    public ProcessingInfo() {
        this.start();
    }

    public ProcessingInfo start() {
        this.start = System.nanoTime();
        this.lastStart = System.nanoTime();
        return this;
    }

    public void done(String string) {
        this.list.add(new Measurement(string, System.nanoTime() - this.lastStart));
        this.lastStart = System.nanoTime();
    }

    public void done(String string, long l) {
        this.list.add(new Measurement(string, l));
    }

    public void info(String string) {
        this.list.add(new Label(string));
    }

    public void dump() {
        System.out.println(this.toString());
    }

    public void dump(Logger logger) {
        logger.info("\n" + this.toString());
    }

    public String toHtml() {
        ConsoleTable consoleTable = this.createConsoleTable();
        return consoleTable.toHtml();
    }

    public String toString() {
        ConsoleTable consoleTable = this.createConsoleTable();
        return consoleTable.toString();
    }

    private ConsoleTable createConsoleTable() {
        ConsoleTable consoleTable = new ConsoleTable();
        long l = 0L;
        for (Item item : this.list) {
            consoleTable.add(item.toArray());
            if (!(item instanceof Measurement)) continue;
            Measurement measurement = (Measurement)item;
            l += measurement.getNanos();
        }
        long l2 = System.nanoTime() - this.start;
        long l3 = l2 - l;
        if (l3 / 1000000L > 0L) {
            consoleTable.add(new Measurement("Unmeasured", l3).toArray());
        }
        consoleTable.add("Total", ": " + l2 / 1000000L + " ms");
        return consoleTable;
    }

    public void clearTimer() {
        this.lastStart = System.nanoTime();
    }

    public void add(SubMeasurement subMeasurement) {
        this.list.add(subMeasurement);
    }
}

