/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplane;

import com.google.common.io.ByteSource;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import nl.bimbase.bimworks.storage.GetArgs;
import nl.bimbase.bimworks.storage.PutArgs;
import nl.bimbase.bimworks.storage.StorageBackendException;
import nl.bimbase.bimworks.storage.UnmetDurabilityScopeStorageBackendException;
import nl.bimbase.bimworks.storage.WriteSlotInterface;
import nl.sascom.backplane.StorageManager;

public class ChrootedStorageManager
implements StorageManager {
    private StorageManager parent;
    private Path parentPath;

    public ChrootedStorageManager(StorageManager storageManager, Path path) {
        this.parent = storageManager;
        this.parentPath = path;
    }

    @Override
    public Path getFile(Path path, boolean bl, GetArgs getArgs) throws StorageBackendException {
        return this.parent.getFile(this.parentPath.resolve(path), bl, getArgs);
    }

    @Override
    public SeekableByteChannel getSeekableByteChannel(Path path, GetArgs getArgs) throws StorageBackendException {
        return this.parent.getSeekableByteChannel(this.parentPath.resolve(path), getArgs);
    }

    @Override
    public ByteSource getByteSource(Path path) throws StorageBackendException {
        return this.parent.getByteSource(this.parentPath.resolve(path));
    }

    @Override
    public WriteSlotInterface createWriteSlot(Path path, boolean bl, PutArgs putArgs) throws UnmetDurabilityScopeStorageBackendException {
        return this.parent.createWriteSlot(this.parentPath.resolve(path), bl, putArgs);
    }

    @Override
    public StorageManager chroot(Path path) {
        return new ChrootedStorageManager(this, path);
    }

    @Override
    public Path resolve(String string) {
        return this.parent.resolve(this.parentPath.toString() + "/" + string);
    }
}

