package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import nl.sascom.backplanepublic.common.Response;

public class QuantityValueQuery implements Comparable<QuantityValueQuery>, CompareQuery {
	private String name;
	private Operator operator;
	private JsonNode value;

	public QuantityValueQuery(String name, Operator operator, JsonNode value) {
		this.name = name;
		this.operator = operator;
		this.value = value;
	}
	
	public ObjectNode toJson() {
		ObjectNode objectNode = Response.createObject();
		objectNode.put("name", name);
		objectNode.set("operator", operator.toJson());
		if (value != null) {
			objectNode.set("value", value);
		}
		return objectNode;
	}
	
	public Operator getOperator() {
		return operator;
	}
	
	public JsonNode getValue() {
		return value;
	}

	public String getName() {
		return name;
	}
	
	@Override
	public int compareTo(QuantityValueQuery o) {
		return this.getName().compareTo(o.getName());
	}

	public static QuantityValueQuery of(JsonNode quantityNode) {
		return new QuantityValueQuery(quantityNode.get("name").asText(), quantityNode.hasNonNull("operator") ? Operator.bySymbol(quantityNode.get("operator").asText()) : Operator.EXISTS, quantityNode.get("value"));
	}

	public String getFullName() {
		return name;
	}

	public String getFullFieldName() {
		return name;
	}
}
