package nl.bimbase.bimworks.client;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;

public enum Operator {
	EQUALS("="),
	LESS_THAN("<"),
	GREATER_THAN(">"),
	LESS_THAN_OR_EQUALS("<="),
	GREATER_THAN_OR_EQUALS(">="), 
	EXISTS(""), 
	STARTS_WITH("startsWith"), 
	BETWEEN("between"), 
	LIKE("like");

	private String symbol;
	
	private static final Map<String, Operator> SYMBOL_MAP = new HashMap<>();
	
	static {
		for (Operator operator : values()) {
			SYMBOL_MAP.put(operator.symbol, operator);
		}
	}
	
	static Operator bySymbol(String symbol) {
		return SYMBOL_MAP.get(symbol);
	}
	
	Operator(String symbol) {
		this.symbol = symbol;
	}
	
	JsonNode toJson() {
		return TextNode.valueOf(symbol);
	}

	public boolean evaluate(double value1, double value2) {
		switch(this) {
		case BETWEEN:
			break;
		case EQUALS:
			return value1 == value2;
		case EXISTS:
			break;
		case GREATER_THAN:
			return value1 > value2;
		case GREATER_THAN_OR_EQUALS:
			return value1 >= value2;
		case LESS_THAN:
			return value1 < value2;
		case LESS_THAN_OR_EQUALS:
			return value1 <= value2;
		case LIKE:
			break;
		case STARTS_WITH:
			break;
		default:
			break;
		}
		return false;
	}

	public static Operator of(double value1, double value2) {
		if (value1 == value2) {
			return EQUALS;
		}
		if (value1 > value2) {
			return GREATER_THAN;
		}
		if (value1 < value2) {
			return LESS_THAN;
		}
		return null;
	}
}
