/*
 * Decompiled with CFR 0.152.
 */
package nl.sascom.backplane.appbase.library.ssh;

import com.google.common.base.Charsets;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import nl.sascom.backplane.appbase.library.ssh.SshChannel;
import nl.sascom.backplane.appbase.library.ssh.SshConnectException;
import nl.sascom.backplane.appbase.library.ssh.SshException;
import nl.sascom.backplane.appbase.library.ssh.SshSettings;
import nl.sascom.backplanepublic.common.logging.Log;

public class SshClient
implements AutoCloseable {
    private JSch jSch;
    private Session session;
    private Log log;
    private Channel shellChannel;
    private String address;
    private String username;

    public SshClient(JSch jSch, Log log) {
        this.jSch = jSch;
        this.log = log;
    }

    public void reconnect() throws SshException {
        this.connect(this.username, this.address, SshSettings.DEFAULT);
    }

    public void connect(String string, String string2) throws SshException {
        this.connect(string, string2, SshSettings.DEFAULT.maxRetries(10));
    }

    public void connect(String string, String string2, SshSettings sshSettings) throws SshException {
        block22: {
            this.username = string;
            this.address = string2;
            Properties properties = new Properties();
            properties.put("StrictHostKeyChecking", "no");
            try {
                this.session = this.jSch.getSession(string, string2, 22);
                this.session.setTimeout(2000);
                try {
                    this.session.setConfig(properties);
                    for (int i = 0; i <= sshSettings.maxRetries; ++i) {
                        try {
                            this.log.info("Connecting SSH (" + i + ")");
                            this.session.connect();
                            break;
                        }
                        catch (JSchException jSchException) {
                            if (jSchException.getCause() instanceof ConnectException || jSchException.getMessage().contains("timeout")) {
                                if (i >= sshSettings.maxRetries) {
                                    throw jSchException;
                                }
                                try {
                                    Thread.sleep((1 + i) * 1000);
                                }
                                catch (InterruptedException interruptedException) {
                                    if (!sshSettings.logError) continue;
                                    this.log.error(interruptedException);
                                }
                                continue;
                            }
                            if (sshSettings.logError) {
                                this.log.error(jSchException);
                            }
                            throw new SshConnectException(jSchException.getMessage(), (Exception)((Object)jSchException));
                        }
                    }
                    if (!this.session.isConnected()) break block22;
                    this.shellChannel = this.session.openChannel("shell");
                    this.log.info("Successfully connected");
                    try (SshChannel sshChannel = this.openSshChannel();){
                        sshChannel.exec("ls", sshSettings.logInfo(false).logError(false).logOutput(false));
                    }
                    return;
                }
                catch (JSchException jSchException) {
                    if (jSchException.getCause() instanceof ConnectException || jSchException.getCause() instanceof NoRouteToHostException) {
                        throw new SshConnectException(jSchException.getMessage(), (Exception)((Object)jSchException));
                    }
                    if (jSchException.getMessage().equals("Auth fail")) {
                        throw new SshConnectException(jSchException.getMessage(), (Exception)((Object)jSchException));
                    }
                    throw new SshConnectException(jSchException.getMessage(), (Exception)((Object)jSchException));
                }
            }
            catch (JSchException jSchException) {
                new SshConnectException(jSchException.getMessage(), (Exception)((Object)jSchException));
            }
        }
    }

    @Override
    public void close() {
        if (this.shellChannel != null) {
            this.shellChannel.disconnect();
        }
        this.log.info("Connection to " + this.address + " closed");
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exec(String string, boolean bl, boolean bl2, int n) throws SshException {
        final StringBuilder stringBuilder = new StringBuilder();
        final StringBuilder stringBuilder2 = new StringBuilder();
        this.log.info("Executing " + string);
        for (int i = 0; i <= n; ++i) {
            ChannelExec channelExec;
            this.log.info("Opening exec channel (" + i + ")");
            try {
                channelExec = (ChannelExec)this.session.openChannel("exec");
            }
            catch (JSchException jSchException) {
                this.log.error(jSchException);
                if (jSchException.getMessage().equals("session is down") && i <= n) {
                    this.reconnect();
                }
                try {
                    Thread.sleep(i * 1000);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                continue;
            }
            final CountDownLatch countDownLatch = new CountDownLatch(2);
            channelExec.setCommand(string);
            final StringBuilder stringBuilder3 = new StringBuilder();
            OutputStream outputStream = new OutputStream(){

                @Override
                public void write(int n) throws IOException {
                }

                @Override
                public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
                    String string = new String(byArray, n, n2, Charsets.UTF_8);
                    stringBuilder2.append(string);
                    stringBuilder.append(string);
                    String string2 = stringBuilder.toString();
                    while (string2.contains("\n")) {
                        String string3 = string2.substring(0, string2.indexOf("\n"));
                        SshClient.this.log.info(string3);
                        string2 = string2.substring(string2.indexOf("\n") + 1);
                    }
                    stringBuilder.delete(0, stringBuilder.length());
                    stringBuilder.append(string2);
                }

                @Override
                public void close() throws IOException {
                    countDownLatch.countDown();
                }
            };
            OutputStream outputStream2 = new OutputStream(){

                @Override
                public void write(int n) throws IOException {
                }

                @Override
                public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
                    String string = new String(byArray, n, n2, Charsets.UTF_8);
                    stringBuilder3.append(string);
                    stringBuilder2.append(string);
                    String string2 = stringBuilder3.toString();
                    while (string2.contains("\n")) {
                        String string3 = string2.substring(0, string2.indexOf("\n"));
                        SshClient.this.log.error(string3);
                        string2 = string2.substring(string2.indexOf("\n") + 1);
                    }
                    stringBuilder3.delete(0, stringBuilder3.length());
                    stringBuilder3.append(string2);
                }

                @Override
                public void close() throws IOException {
                    countDownLatch.countDown();
                }
            };
            channelExec.setOutputStream(outputStream);
            channelExec.setErrStream(outputStream2);
            try {
                channelExec.connect();
            }
            catch (JSchException jSchException) {
                this.log.error(jSchException);
                channelExec.disconnect();
                continue;
            }
            try {
                if (bl) {
                    try {
                        countDownLatch.await(10L, TimeUnit.MINUTES);
                        try {
                            outputStream.flush();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        int n2 = 0;
                        while (!channelExec.isClosed()) {
                            this.log.info("Waiting for channel to close");
                            Thread.sleep(1000L);
                            if (++n2 <= 10) continue;
                            this.log.error("Channel doesn't seem to close");
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.log.error(interruptedException);
                    }
                    if (channelExec.getExitStatus() != 0 && !bl2) {
                        if (i >= n) {
                            throw new SshException("No exit status 0, but " + channelExec.getExitStatus() + " from calling " + string);
                        }
                        this.log.info("Retrying " + string);
                        try {
                            Thread.sleep(i * 1000);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    String string2 = stringBuilder2.toString();
                    return string2;
                }
                String string3 = stringBuilder2.toString();
                return string3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                channelExec.disconnect();
            }
        }
        return stringBuilder2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToRemoteServer(String string, long l, InputStream inputStream) throws IOException, JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.session.openChannel("sftp");
        channelSftp.connect();
        try {
            if (string.contains("/")) {
                channelSftp.cd(string.substring(0, string.lastIndexOf("/")));
                string = string.substring(string.lastIndexOf("/") + 1);
            }
            channelSftp.put(inputStream, string);
        }
        finally {
            channelSftp.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToRemoteServer(String string, byte[] byArray) throws IOException, JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.session.openChannel("sftp");
        channelSftp.connect();
        try {
            if (string.contains("/")) {
                channelSftp.cd(string.substring(0, string.lastIndexOf("/")));
                string = string.substring(string.lastIndexOf("/") + 1);
            }
            channelSftp.put((InputStream)new ByteArrayInputStream(byArray), string);
        }
        finally {
            channelSftp.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromRemoteServer(String string, OutputStream outputStream) throws IOException, JSchException, SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.session.openChannel("sftp");
        channelSftp.connect();
        try {
            channelSftp.get(string, outputStream);
        }
        finally {
            channelSftp.disconnect();
        }
    }

    public SshChannel openSshChannel() throws SshException {
        if (this.session.isConnected()) {
            return new SshChannel(this.session, this.log);
        }
        throw new SshException("Session is closed");
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }
}

