/*
 * Decompiled with CFR 0.152.
 */
package nl.bimbase.bimworks.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import nl.bimbase.bimworks.client.CompareQuery;
import nl.bimbase.bimworks.client.Operator;
import nl.sascom.backplanepublic.common.Response;

public class QuantityValueQuery
implements Comparable<QuantityValueQuery>,
CompareQuery {
    private String name;
    private Operator operator;
    private JsonNode value;

    public QuantityValueQuery(String string, Operator operator, JsonNode jsonNode) {
        this.name = string;
        this.operator = operator;
        this.value = jsonNode;
    }

    public ObjectNode toJson() {
        ObjectNode objectNode = Response.createObject();
        objectNode.put("name", this.name);
        objectNode.set("operator", this.operator.toJson());
        if (this.value != null) {
            objectNode.set("value", this.value);
        }
        return objectNode;
    }

    @Override
    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public JsonNode getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(QuantityValueQuery quantityValueQuery) {
        return this.getName().compareTo(quantityValueQuery.getName());
    }

    public static QuantityValueQuery of(JsonNode jsonNode) {
        return new QuantityValueQuery(jsonNode.get("name").asText(), jsonNode.hasNonNull("operator") ? Operator.bySymbol(jsonNode.get("operator").asText()) : Operator.EXISTS, jsonNode.get("value"));
    }

    public String getFullName() {
        return this.name;
    }

    public String getFullFieldName() {
        return this.name;
    }
}

