package nl.bimbase.bimworks.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import com.fasterxml.jackson.databind.node.ObjectNode;

import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.NodeClientException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;

public class AuthApi {

	private final BimWorksClient bimWorksClient;

	public AuthApi(BimWorksClient bimWorksClient) {
		this.bimWorksClient = bimWorksClient;
	}
	
	public ObjectNode loginWithUsernamePassword(String username, String password) throws BimWorksException {
		try {
			return bimWorksClient.getNodeClient().loginApp(username, password);
		} catch (NodeClientException e) {
			throw new BimWorksException(e);
		}
	}

	public void loginWithApiToken(String apiToken) throws BimWorksException {
		Request request = bimWorksClient.getNodeClient().createRequest();
		request.setProject("BimRepository");
		request.setTaskName("LoginWithApiToken");
		ObjectNode input = request.createObject();
		input.put("token", apiToken);
		request.setInput(input);
		try {
			Response response = bimWorksClient.getNodeClient().executeSync(request, 10, TimeUnit.SECONDS);
			if (response.getOutput() != null && response.getOutput().has("auth")) {
				ObjectNode auth = (ObjectNode) response.getOutput().get("auth");
				bimWorksClient.getNodeClient().setAuth(auth);
				bimWorksClient.getNodeClient().getNodeTransport().connectAsync(auth);
			} else {
				throw new BimWorksException("No auth in response to login call " + (response.getErrorNode() != null ? response.getErrorNode().toString() : "") + response);
			}
		} catch (IOException e) {
			e.printStackTrace();
		} catch (ExecuteException e) {
			throw new BimWorksException(e);
		}
	}

	public void loginAnonymous() throws BimWorksException {
		Request request = bimWorksClient.getNodeClient().createRequest();
		request.setProject("BimRepository");
		request.setTaskName("LoginAnonymous");
		try {
			Response response = bimWorksClient.getNodeClient().executeSync(request, 10, TimeUnit.SECONDS);
			if (response.getOutput() != null && response.getOutput().has("auth")) {
				ObjectNode auth = (ObjectNode) response.getOutput().get("auth");
				bimWorksClient.getNodeClient().setAuth(auth);
				bimWorksClient.getNodeClient().getNodeTransport().connectAsync(auth);
			} else {
				throw new BimWorksException("No auth in response to login call " + (response.getErrorNode() != null ? response.getErrorNode().toString() : "") + response);
			}
		} catch (IOException e) {
			e.printStackTrace();
		} catch (ExecuteException e) {
			throw new BimWorksException(e);
		}
	}
}