package nl.bimbase.bimworks.client;

import java.time.Duration;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import nl.sascom.backplanepublic.common.ClientTask;
import nl.sascom.backplanepublic.common.ExecuteException;
import nl.sascom.backplanepublic.common.Request;
import nl.sascom.backplanepublic.common.Response;

public class Bim {

	private BimWorksClient bimWorksClient;

	public Bim(BimWorksClient bimWorksClient) {
		this.bimWorksClient = bimWorksClient;
	}
	
	public ArrayNode query(BimQuery bimQuery, String[] paths, Set<UUID> versionUuids) throws BimWorksException, InterruptedException {
		return query(bimQuery, paths, versionUuids.toArray(new UUID[0]));
	}
	
	public ArrayNode query(BimQuery bimQuery, String[] paths, UUID... versionUuids) throws BimWorksException, InterruptedException {
		Request request = bimWorksClient.createRequest();
		request.setTaskName("TableExport");
		request.put("type", "JSON");
		request.put("output", "RESPONSE");
		request.getObjectInput().set("query", bimQuery.toJson());
		ArrayNode pathsNode = Response.createArray();
		for (String path : paths) {
			pathsNode.add(path);
		}
		request.getObjectInput().set("paths", pathsNode);
		ArrayNode versionUuidsNode = Response.createArray();
		for (UUID versionUuid : versionUuids) {
			versionUuidsNode.add(versionUuid.toString());
		}
		request.getObjectInput().set("models", versionUuidsNode);
		request.setTimeOut(1, TimeUnit.MINUTES);
		ClientTask task = bimWorksClient.createAsyncTask(request);
		try {
			task.exec();
			return task.await(1, TimeUnit.MINUTES).getArrayOutput();
		} catch (ExecuteException e) {
			throw new BimWorksException(e);
		}
	}

	public ObjectNode queryDelegated(BimQuery query, String[] paths, Duration validFor, UUID... versionUuids) throws BimWorksException, InterruptedException {
		Request request = bimWorksClient.createRequest();
		request.setTaskName("GenerateQueryToken");
		request.getObjectInput().set("query", query.toJson());
		request.getObjectInput().put("expires_seconds", validFor.toMillis());
		request.getObjectInput().put("type", "JSON");
		request.getObjectInput().put("output", "RESPONSE");
		ArrayNode pathsNode = Response.createArray();
		for (String path : paths) {
			pathsNode.add(path);
		}
		request.getObjectInput().set("paths", pathsNode);

		ArrayNode versionUuidsNode = Response.createArray();
		for (UUID versionUuid : versionUuids) {
			versionUuidsNode.add(versionUuid.toString());
		}
		request.getObjectInput().set("models", versionUuidsNode);
		request.setTimeOut(1, TimeUnit.MINUTES);
		ClientTask task = bimWorksClient.createAsyncTask(request);
		try {
			task.exec();
			return task.await(1, TimeUnit.MINUTES).getObjectOutput();
		} catch (ExecuteException e) {
			throw new BimWorksException(e);
		}
	}
	
	public ArrayNode queryWithToken(ObjectNode payload) throws BimWorksException {
		Request request = bimWorksClient.createRequest();
		request.setInput(payload.get("input"));
		request.setTask((ObjectNode)payload.get("task"));
		request.setTimeOut(4, TimeUnit.HOURS);
		ClientTask task = bimWorksClient.createAsyncTask(request);
		try {
			task.exec();
			return task.await(4, TimeUnit.HOURS).getArrayOutput();
		} catch (ExecuteException e) {
			throw new BimWorksException(e);
		} catch (InterruptedException e) {
			throw new BimWorksException(e.getMessage());
		}
	}
}
