/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze.treewalker;

import java.io.Serializable;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.analyze.treewalker.steps.WalkList;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerBaseVisitor;
import nl.basjes.parse.useragent.parser.UserAgentTreeWalkerParser;
import nl.basjes.parse.useragent.yauaa.shaded.org.antlr.v4.runtime.ParserRuleContext;
import nl.basjes.parse.useragent.yauaa.shaded.org.antlr.v4.runtime.tree.ParseTree;
import nl.basjes.parse.useragent.yauaa.shaded.org.antlr.v4.runtime.tree.RuleNode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TreeExpressionEvaluator
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(TreeExpressionEvaluator.class);
    private final boolean verbose;
    private final String requiredPatternText;
    private final WalkList walkList;
    private final String fixedValue;

    private TreeExpressionEvaluator() {
        this.requiredPatternText = null;
        this.verbose = false;
        this.fixedValue = null;
        this.walkList = null;
    }

    public TreeExpressionEvaluator(ParserRuleContext requiredPattern, Matcher matcher, boolean verbose) {
        this.requiredPatternText = requiredPattern.getText();
        this.verbose = verbose;
        this.fixedValue = this.calculateFixedValue(requiredPattern);
        this.walkList = new WalkList(requiredPattern, matcher.getLookups(), matcher.getLookupSets(), verbose);
    }

    public boolean isEmpty() {
        return this.walkList.isEmpty();
    }

    public void destroy() {
        this.walkList.destroy();
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    private String calculateFixedValue(ParserRuleContext requiredPattern) {
        return (String)new UserAgentTreeWalkerBaseVisitor<String>(){

            @Override
            protected boolean shouldVisitNextChild(RuleNode node, String currentResult) {
                return currentResult == null;
            }

            @Override
            protected String aggregateResult(String aggregate, String nextResult) {
                return nextResult == null ? aggregate : nextResult;
            }

            @Override
            public String visitMatcherPathLookup(UserAgentTreeWalkerParser.MatcherPathLookupContext ctx) {
                return this.visitLookupsFailOnFixedString(ctx.matcher());
            }

            @Override
            public String visitMatcherPathLookupContains(UserAgentTreeWalkerParser.MatcherPathLookupContainsContext ctx) {
                return this.visitLookupsFailOnFixedString(ctx.matcher());
            }

            @Override
            public String visitMatcherPathLookupPrefix(UserAgentTreeWalkerParser.MatcherPathLookupPrefixContext ctx) {
                return this.visitLookupsFailOnFixedString(ctx.matcher());
            }

            @Override
            public String visitMatcherPathIsInLookup(UserAgentTreeWalkerParser.MatcherPathIsInLookupContext ctx) {
                return this.visitLookupsFailOnFixedString(ctx.matcher());
            }

            @Override
            public String visitMatcherPathIsInLookupContains(UserAgentTreeWalkerParser.MatcherPathIsInLookupContainsContext ctx) {
                return this.visitLookupsFailOnFixedString(ctx.matcher());
            }

            @Override
            public String visitMatcherPathIsNotInLookupContains(UserAgentTreeWalkerParser.MatcherPathIsNotInLookupContainsContext ctx) {
                return this.visitLookupsFailOnFixedString(ctx.matcher());
            }

            @Override
            public String visitMatcherPathIsInLookupPrefix(UserAgentTreeWalkerParser.MatcherPathIsInLookupPrefixContext ctx) {
                return this.visitLookupsFailOnFixedString(ctx.matcher());
            }

            @Override
            public String visitMatcherPathIsNotInLookupPrefix(UserAgentTreeWalkerParser.MatcherPathIsNotInLookupPrefixContext ctx) {
                return this.visitLookupsFailOnFixedString(ctx.matcher());
            }

            private String visitLookupsFailOnFixedString(ParseTree matcherTree) {
                String value = (String)this.visit(matcherTree);
                if (value == null) {
                    return null;
                }
                throw new InvalidParserConfigurationException("A lookup for a fixed input value is a needless complexity.");
            }

            @Override
            public String visitPathFixedValue(UserAgentTreeWalkerParser.PathFixedValueContext ctx) {
                return ctx.value.getText();
            }
        }.visit(requiredPattern);
    }

    public WalkList.WalkResult evaluate(ParseTree tree, String key, String value) {
        if (this.verbose) {
            LOG.info("===========================================");
            LOG.info("Evaluate: {} => {}", (Object)key, (Object)value);
            LOG.info("Pattern : {}", (Object)this.requiredPatternText);
            LOG.info("WalkList: {}", (Object)this.walkList);
        }
        WalkList.WalkResult result = this.walkList.walk(tree, value);
        if (this.verbose) {
            LOG.info("Evaluate: Result = {}", (Object)(result == null ? "null" : result.getValue()));
        }
        return result;
    }

    public boolean mustHaveMatches() {
        return this.walkList.mustHaveMatches();
    }

    public WalkList getWalkListForUnitTesting() {
        return this.walkList;
    }

    public long pruneTrailingStepsThatCannotFail() {
        return this.walkList.pruneTrailingStepsThatCannotFail();
    }
}

